/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.MixInResolver;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_STRING = String.class;
    private static final Class<?> CLS_NUMBER = Number.class;
    private static final Class<?> CLS_JSON_NODE = JsonNode.class;
    private static final AnnotatedClass OBJECT_AC = new AnnotatedClass(CLS_OBJECT);
    private static final AnnotatedClass STRING_AC = new AnnotatedClass(CLS_STRING);
    private static final AnnotatedClass BOOLEAN_AC = new AnnotatedClass(Boolean.TYPE);
    private static final AnnotatedClass INT_AC = new AnnotatedClass(Integer.TYPE);
    private static final AnnotatedClass LONG_AC = new AnnotatedClass(Long.TYPE);
    private static final AnnotatedClass NUMBER_AC = new AnnotatedClass(CLS_NUMBER);
    protected final MixInResolver _mixInResolver;
    protected final MapperConfig<?> _config;
    protected HashMap<JavaType, AnnotatedClass> _resolvedFullAnnotations;
    protected HashMap<JavaType, BasicBeanDescription> _resolvedSerBeanDescs;
    protected HashMap<JavaType, BasicBeanDescription> _resolvedDeserBeanDescs;

    public BasicClassIntrospector() {
        this._config = null;
        this._mixInResolver = null;
    }

    protected BasicClassIntrospector(MapperConfig<?> config) {
        this._config = Objects.requireNonNull(config, "Can not pass null `config`");
        this._mixInResolver = config;
    }

    @Override
    public BasicClassIntrospector forMapper() {
        return this;
    }

    @Override
    public BasicClassIntrospector forOperation(MapperConfig<?> config) {
        return new BasicClassIntrospector(config);
    }

    @Override
    public AnnotatedClass introspectClassAnnotations(JavaType type) {
        AnnotatedClass ac = this._findStdTypeDef(type);
        if (ac != null) {
            return ac;
        }
        if (this._resolvedFullAnnotations == null) {
            this._resolvedFullAnnotations = new HashMap();
        } else {
            ac = this._resolvedFullAnnotations.get(type);
            if (ac != null) {
                return ac;
            }
        }
        ac = this._resolveAnnotatedClass(type);
        this._resolvedFullAnnotations.put(type, ac);
        return ac;
    }

    @Override
    public AnnotatedClass introspectDirectClassAnnotations(JavaType type) {
        AnnotatedClass ac = this._findStdTypeDef(type);
        return ac != null ? ac : this._resolveAnnotatedWithoutSuperTypes(type);
    }

    protected AnnotatedClass _resolveAnnotatedClass(JavaType type) {
        return AnnotatedClassResolver.resolve(this._config, type, this._mixInResolver);
    }

    protected AnnotatedClass _resolveAnnotatedWithoutSuperTypes(JavaType type) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(this._config, type, this._mixInResolver);
    }

    @Override
    public BasicBeanDescription introspectForSerialization(JavaType type) {
        BasicBeanDescription desc = this._findStdTypeDesc(type);
        if (desc == null && (desc = this._findStdJdkCollectionDesc(type)) == null) {
            if (this._resolvedSerBeanDescs == null) {
                this._resolvedSerBeanDescs = new HashMap();
            } else {
                desc = this._resolvedSerBeanDescs.get(type);
                if (desc != null) {
                    return desc;
                }
            }
            desc = BasicBeanDescription.forSerialization(this.collectProperties(type, this.introspectClassAnnotations(type), true, "set"));
            this._resolvedSerBeanDescs.put(type, desc);
        }
        return desc;
    }

    @Override
    public BasicBeanDescription introspectForDeserialization(JavaType type) {
        BasicBeanDescription desc = this._findStdTypeDesc(type);
        if (desc == null && (desc = this._findStdJdkCollectionDesc(type)) == null) {
            if (this._resolvedDeserBeanDescs == null) {
                this._resolvedDeserBeanDescs = new HashMap();
            } else {
                desc = this._resolvedDeserBeanDescs.get(type);
                if (desc != null) {
                    return desc;
                }
            }
            desc = BasicBeanDescription.forDeserialization(this.collectProperties(type, this.introspectClassAnnotations(type), false, "set"));
            this._resolvedDeserBeanDescs.put(type, desc);
        }
        return desc;
    }

    @Override
    public BasicBeanDescription introspectForDeserializationWithBuilder(JavaType type, BeanDescription valueTypeDesc) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(type, this.introspectClassAnnotations(type), valueTypeDesc, false));
    }

    @Override
    public BasicBeanDescription introspectForCreation(JavaType type) {
        BasicBeanDescription desc = this._findStdTypeDesc(type);
        if (desc == null && (desc = this._findStdJdkCollectionDesc(type)) == null) {
            desc = BasicBeanDescription.forDeserialization(this.collectProperties(type, this.introspectClassAnnotations(type), false, "set"));
        }
        return desc;
    }

    protected POJOPropertiesCollector collectProperties(JavaType type, AnnotatedClass classDef, boolean forSerialization, String mutatorPrefix) {
        AccessorNamingStrategy accNaming = type.isRecordType() ? this._config.getAccessorNaming().forRecord(this._config, classDef) : this._config.getAccessorNaming().forPOJO(this._config, classDef);
        return this.constructPropertyCollector(type, classDef, forSerialization, accNaming);
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(JavaType type, AnnotatedClass builderClassDef, BeanDescription valueTypeDesc, boolean forSerialization) {
        AccessorNamingStrategy accNaming = this._config.getAccessorNaming().forBuilder(this._config, builderClassDef, valueTypeDesc);
        return this.constructPropertyCollector(type, builderClassDef, forSerialization, accNaming);
    }

    protected POJOPropertiesCollector constructPropertyCollector(JavaType type, AnnotatedClass classDef, boolean forSerialization, AccessorNamingStrategy accNaming) {
        return new POJOPropertiesCollector(this._config, forSerialization, type, classDef, accNaming);
    }

    protected BasicBeanDescription _findStdTypeDesc(JavaType type) {
        AnnotatedClass ac = this._findStdTypeDef(type);
        return ac == null ? null : BasicBeanDescription.forOtherUse(this._config, type, ac);
    }

    protected AnnotatedClass _findStdTypeDef(JavaType type) {
        Class<?> rawType = type.getRawClass();
        if (rawType.isPrimitive()) {
            if (rawType == Integer.TYPE) {
                return INT_AC;
            }
            if (rawType == Long.TYPE) {
                return LONG_AC;
            }
            if (rawType == Boolean.TYPE) {
                return BOOLEAN_AC;
            }
        } else if (ClassUtil.isJDKClass(rawType)) {
            if (rawType == CLS_STRING) {
                return STRING_AC;
            }
            if (rawType == Integer.class) {
                return INT_AC;
            }
            if (rawType == Long.class) {
                return LONG_AC;
            }
            if (rawType == Boolean.class) {
                return BOOLEAN_AC;
            }
            if (rawType == CLS_OBJECT) {
                return OBJECT_AC;
            }
            if (rawType == CLS_NUMBER) {
                return NUMBER_AC;
            }
        } else if (CLS_JSON_NODE.isAssignableFrom(rawType)) {
            return new AnnotatedClass(rawType);
        }
        return null;
    }

    protected BasicBeanDescription _findStdJdkCollectionDesc(JavaType type) {
        if (this._isStdJDKCollection(type)) {
            return BasicBeanDescription.forOtherUse(this._config, type, this.introspectClassAnnotations(type));
        }
        return null;
    }

    private boolean _isStdJDKCollection(JavaType type) {
        if (!type.isContainerType() || type.isArrayType()) {
            return false;
        }
        Class<?> raw = type.getRawClass();
        return ClassUtil.isJDKClass(raw) && (Collection.class.isAssignableFrom(raw) || Map.class.isAssignableFrom(raw));
    }
}

