/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

class CollectorBase {
    protected static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Class<?> CLS_OBJECT = Object.class;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _intr;

    protected CollectorBase(MapperConfig<?> config) {
        this._config = config;
        this._intr = config == null ? null : config.getAnnotationIntrospector();
    }

    protected final AnnotationCollector collectAnnotations(Annotation[] anns) {
        AnnotationCollector c = AnnotationCollector.emptyCollector();
        for (Annotation ann : anns) {
            c = c.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c = this.collectFromBundle(c, ann);
        }
        return c;
    }

    protected final AnnotationCollector collectAnnotations(AnnotationCollector c, Annotation[] anns) {
        for (Annotation ann : anns) {
            c = c.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c = this.collectFromBundle(c, ann);
        }
        return c;
    }

    protected final AnnotationCollector collectFromBundle(AnnotationCollector c, Annotation bundle) {
        for (Annotation ann : CollectorBase._findClassAnnotations(bundle.annotationType())) {
            if (CollectorBase._ignorableAnnotation(ann)) continue;
            if (this._intr.isAnnotationBundle(ann)) {
                if (c.isPresent(ann)) continue;
                c = c.addOrOverride(ann);
                c = this.collectFromBundle(c, ann);
                continue;
            }
            c = c.addOrOverride(ann);
        }
        return c;
    }

    protected final AnnotationCollector collectDefaultAnnotations(AnnotationCollector c, Annotation[] anns) {
        for (Annotation ann : anns) {
            if (c.isPresent(ann)) continue;
            c = c.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c = this.collectDefaultFromBundle(c, ann);
        }
        return c;
    }

    protected final AnnotationCollector collectDefaultFromBundle(AnnotationCollector c, Annotation bundle) {
        for (Annotation ann : CollectorBase._findClassAnnotations(bundle.annotationType())) {
            if (CollectorBase._ignorableAnnotation(ann) || c.isPresent(ann)) continue;
            c = c.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c = this.collectFromBundle(c, ann);
        }
        return c;
    }

    protected static final boolean _ignorableAnnotation(Annotation a) {
        return a instanceof Target || a instanceof Retention;
    }

    static AnnotationMap _emptyAnnotationMap() {
        return new AnnotationMap();
    }

    static AnnotationMap[] _emptyAnnotationMaps(int count) {
        if (count == 0) {
            return NO_ANNOTATION_MAPS;
        }
        AnnotationMap[] maps = new AnnotationMap[count];
        for (int i = 0; i < count; ++i) {
            maps[i] = CollectorBase._emptyAnnotationMap();
        }
        return maps;
    }

    private static Annotation[] _findClassAnnotations(Class<?> cls) {
        if (cls == CLS_OBJECT) {
            return NO_ANNOTATIONS;
        }
        return cls.getDeclaredAnnotations();
    }
}

