/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import java.io.Serializable;
import java.util.Collection;

public class TypeResolverProvider
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected static final StdTypeResolverBuilder NO_RESOLVER = StdTypeResolverBuilder.noTypeInfoBuilder();

    public TypeSerializer findTypeSerializer(SerializerProvider ctxt, JavaType baseType, AnnotatedClass classInfo) {
        SerializationConfig config = ctxt.getConfig();
        TypeResolverBuilder<?> b = this._findTypeResolver(config, classInfo, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass(config, classInfo);
        }
        if (b == null) {
            return null;
        }
        return b.buildTypeSerializer(ctxt, baseType, subtypes);
    }

    public TypeDeserializer findTypeDeserializer(DeserializationContext ctxt, JavaType baseType, AnnotatedClass classInfo) {
        JavaType defaultType;
        DeserializationConfig config = ctxt.getConfig();
        TypeResolverBuilder<?> b = this._findTypeResolver(config, classInfo, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
            if (b == null) {
                return null;
            }
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByTypeId(config, classInfo);
        }
        if (b.getDefaultImpl() == null && baseType.isAbstract() && (defaultType = config.mapAbstractType(baseType)) != null && !defaultType.hasRawClass(baseType.getRawClass())) {
            b = b.defaultImpl(defaultType.getRawClass());
        }
        return b.buildTypeDeserializer(ctxt, baseType, subtypes);
    }

    public TypeSerializer findPropertyTypeSerializer(SerializerProvider ctxt, AnnotatedMember accessor, JavaType baseType) {
        TypeResolverBuilder<?> b = null;
        SerializationConfig config = ctxt.getConfig();
        if (!baseType.isContainerType() && !baseType.isReferenceType()) {
            b = this._findTypeResolver(config, accessor, baseType);
        }
        if (b == null) {
            return this.findTypeSerializer(ctxt, baseType, ctxt.introspectClassAnnotations(baseType));
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass(config, accessor, baseType);
        return b.buildTypeSerializer(ctxt, baseType, subtypes);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationContext ctxt, AnnotatedMember accessor, JavaType baseType) {
        JavaType defaultType;
        TypeResolverBuilder<?> b = null;
        DeserializationConfig config = ctxt.getConfig();
        if (!baseType.isContainerType() && !baseType.isReferenceType()) {
            b = this._findTypeResolver(config, accessor, baseType);
        }
        if (b == null) {
            return this.findTypeDeserializer(ctxt, baseType, ctxt.introspectClassAnnotations(baseType));
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByTypeId(config, accessor, baseType);
        if (b.getDefaultImpl() == null && baseType.isAbstract() && (defaultType = config.mapAbstractType(baseType)) != null && !defaultType.hasRawClass(baseType.getRawClass())) {
            b = b.defaultImpl(defaultType.getRawClass());
        }
        return b.buildTypeDeserializer(ctxt, baseType, subtypes);
    }

    public TypeSerializer findPropertyContentTypeSerializer(SerializerProvider ctxt, AnnotatedMember accessor, JavaType containerType) {
        JavaType contentType = containerType.getContentType();
        if (contentType == null) {
            throw new IllegalArgumentException("Must call method with a container or reference type (got " + containerType + ")");
        }
        SerializationConfig config = ctxt.getConfig();
        TypeResolverBuilder<?> b = this._findTypeResolver(config, accessor, containerType);
        if (b == null) {
            return this.findTypeSerializer(ctxt, contentType, ctxt.introspectClassAnnotations(contentType.getRawClass()));
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass(config, accessor, contentType);
        return b.buildTypeSerializer(ctxt, contentType, subtypes);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationContext ctxt, AnnotatedMember accessor, JavaType containerType) {
        JavaType defaultType;
        JavaType contentType = containerType.getContentType();
        DeserializationConfig config = ctxt.getConfig();
        if (contentType == null) {
            throw new IllegalArgumentException("Must call method with a container or reference type (got " + containerType + ")");
        }
        TypeResolverBuilder<?> b = this._findTypeResolver(config, accessor, containerType);
        if (b == null) {
            return this.findTypeDeserializer(ctxt, contentType, ctxt.introspectClassAnnotations(contentType));
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByTypeId(config, accessor, contentType);
        if (b.getDefaultImpl() == null && contentType.isAbstract() && (defaultType = config.mapAbstractType(contentType)) != null && !defaultType.hasRawClass(contentType.getRawClass())) {
            b = b.defaultImpl(defaultType.getRawClass());
        }
        return b.buildTypeDeserializer(ctxt, contentType, subtypes);
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ann, JavaType baseType) {
        TypeResolverBuilder<?> b;
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        JsonTypeInfo.Value typeInfo = ai.findPolymorphicTypeInfo(config, ann);
        Object customResolverOb = ai.findTypeResolverBuilder(config, ann);
        if (customResolverOb != null) {
            if (typeInfo != null && typeInfo.getIdType() == JsonTypeInfo.Id.NONE) {
                return null;
            }
            if (customResolverOb instanceof Class) {
                Class cls = (Class)customResolverOb;
                b = config.typeResolverBuilderInstance(ann, cls);
            } else {
                b = (TypeResolverBuilder<?>)customResolverOb;
            }
        } else {
            JsonTypeInfo.As inclusion;
            if (typeInfo == null) {
                return null;
            }
            if (typeInfo.getIdType() == JsonTypeInfo.Id.NONE) {
                return NO_RESOLVER;
            }
            if (ann instanceof AnnotatedClass && (inclusion = typeInfo.getInclusionType()) == JsonTypeInfo.As.EXTERNAL_PROPERTY && ann instanceof AnnotatedClass) {
                typeInfo = typeInfo.withInclusionType(JsonTypeInfo.As.PROPERTY);
            }
            b = this._constructStdTypeResolverBuilder(config, typeInfo, baseType);
        }
        Object customIdResolverOb = ai.findTypeIdResolver(config, ann);
        TypeIdResolver idResolver = null;
        if (customIdResolverOb != null && customIdResolverOb instanceof Class) {
            Class cls = (Class)customIdResolverOb;
            idResolver = config.typeIdResolverInstance(ann, cls);
            idResolver.init(baseType);
        }
        b = b.init(typeInfo, idResolver);
        return b;
    }

    protected TypeResolverBuilder<?> _constructStdTypeResolverBuilder(MapperConfig<?> config, JsonTypeInfo.Value typeInfo, JavaType baseType) {
        return new StdTypeResolverBuilder(typeInfo);
    }
}

