/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;

public abstract class TypeSerializerBase
extends TypeSerializer {
    protected final TypeIdResolver _idResolver;
    protected final BeanProperty _property;

    protected TypeSerializerBase(TypeIdResolver idRes, BeanProperty property) {
        this._idResolver = idRes;
        this._property = property;
    }

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public WritableTypeId writeTypePrefix(JsonGenerator g, SerializerProvider ctxt, WritableTypeId idMetadata) throws JacksonException {
        this._generateTypeId(ctxt, idMetadata);
        return g.writeTypePrefix(idMetadata);
    }

    @Override
    public WritableTypeId writeTypeSuffix(JsonGenerator g, SerializerProvider ctxt, WritableTypeId idMetadata) throws JacksonException {
        return g.writeTypeSuffix(idMetadata);
    }

    protected void _generateTypeId(DatabindContext ctxt, WritableTypeId idMetadata) {
        Object id = idMetadata.id;
        if (id == null) {
            Object value = idMetadata.forValue;
            Class typeForId = idMetadata.forValueType;
            id = typeForId == null ? this.idFromValue(ctxt, value) : this.idFromValueAndType(ctxt, value, typeForId);
            idMetadata.id = id;
        }
    }

    protected String idFromValue(DatabindContext ctxt, Object value) {
        String id = this._idResolver.idFromValue(ctxt, value);
        if (id == null) {
            this.handleMissingId(value);
        }
        return id;
    }

    protected String idFromValueAndType(DatabindContext ctxt, Object value, Class<?> type) {
        String id = this._idResolver.idFromValueAndType(ctxt, value, type);
        if (id == null) {
            this.handleMissingId(value);
        }
        return id;
    }

    protected void handleMissingId(Object value) {
    }
}

