/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectWriteContext;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamContext;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JacksonFeature;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class TreeBuildingGenerator
extends JsonGenerator {
    protected static final int DEFAULT_STREAM_WRITE_FEATURES = StreamWriteFeature.collectDefaults();
    protected static final JacksonFeatureSet<StreamWriteCapability> BOGUS_WRITE_CAPABILITIES = JacksonFeatureSet.fromDefaults((JacksonFeature[])StreamWriteCapability.values());
    protected final ObjectWriteContext _objectWriteContext;
    protected final JsonNodeFactory _nodeFactory;
    protected final int _streamWriteFeatures;
    protected RootContext _rootWriteContext;
    protected TreeWriteContext _tokenWriteContext;

    TreeBuildingGenerator(ObjectWriteContext owCtxt, JsonNodeFactory nodeFactory) {
        this._objectWriteContext = owCtxt;
        this._nodeFactory = nodeFactory;
        this._streamWriteFeatures = DEFAULT_STREAM_WRITE_FEATURES;
        this._rootWriteContext = new RootContext(nodeFactory);
        this._tokenWriteContext = this._rootWriteContext;
    }

    public static TreeBuildingGenerator forSerialization(SerializerProvider ctxt, JsonNodeFactory nodeFactory) {
        return new TreeBuildingGenerator(ctxt, nodeFactory);
    }

    public JsonNode treeBuilt() {
        return this._rootWriteContext._node;
    }

    public TokenStreamContext streamWriteContext() {
        return this._tokenWriteContext;
    }

    public Object currentValue() {
        return this._tokenWriteContext.currentValue();
    }

    public void assignCurrentValue(Object v) {
        this._tokenWriteContext.assignCurrentValue(v);
    }

    public ObjectWriteContext objectWriteContext() {
        return this._objectWriteContext;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JsonGenerator configure(StreamWriteFeature f, boolean state) {
        return this;
    }

    public boolean isEnabled(StreamWriteFeature f) {
        return (this._streamWriteFeatures & f.getMask()) != 0;
    }

    public int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return BOGUS_WRITE_CAPABILITIES;
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public Object streamWriteOutputTarget() {
        return null;
    }

    public int streamWriteOutputBuffered() {
        return -1;
    }

    public void writeStartArray() {
        this.writeStartArray(null);
    }

    public void writeStartArray(Object forValue) {
        this._tokenWriteContext = this._tokenWriteContext.createChildArrayContext(forValue);
    }

    public void writeStartArray(Object forValue, int len) {
        this.writeStartArray(forValue);
    }

    public void writeEndArray() {
        if (!this._tokenWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._tokenWriteContext.typeDesc());
        }
        this._tokenWriteContext = this._tokenWriteContext.getParent();
    }

    public final void writeStartObject() {
        this.writeStartObject(null);
    }

    public void writeStartObject(Object forValue) {
        this._tokenWriteContext = this._tokenWriteContext.createChildObjectContext(forValue);
    }

    public void writeStartObject(Object forValue, int size) {
        this.writeStartObject(forValue);
    }

    public final void writeEndObject() {
        if (!this._tokenWriteContext.inObject()) {
            this._reportError("Current context not Object but " + this._tokenWriteContext.typeDesc());
        }
        this._tokenWriteContext = this._tokenWriteContext.getParent();
    }

    public final void writeName(String name) {
        this._tokenWriteContext.writeName(name);
    }

    public void writeName(SerializableString name) {
        this._tokenWriteContext.writeName(name.getValue());
    }

    public void writePropertyId(long id) {
        this.writeName(Long.toString(id));
    }

    public void writeString(String text) {
        if (text == null) {
            this.writeNull();
        } else {
            this._tokenWriteContext.writeString(text);
        }
    }

    public void writeString(char[] text, int offset, int len) {
        this.writeString(new String(text, offset, len));
    }

    public void writeString(SerializableString text) {
        if (text == null) {
            this.writeNull();
        } else {
            this._tokenWriteContext.writeString(text.getValue());
        }
    }

    public void writeString(Reader reader, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] text, int offset, int length) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(SerializableString text) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text) {
        this._tokenWriteContext.writeNode(this._nodeFactory.rawValueNode(new RawValue(text)));
    }

    public void writeRawValue(String text, int offset, int len) {
        if (offset > 0 || len != text.length()) {
            text = text.substring(offset, offset + len);
        }
        this.writeRawValue(text);
    }

    public void writeRawValue(char[] text, int offset, int len) {
        this.writeRawValue(new String(text, offset, len));
    }

    public void writeNumber(short v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
    }

    public void writeNumber(int v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
    }

    public void writeNumber(long v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
    }

    public void writeNumber(double v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
    }

    public void writeNumber(float v) {
        this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
    }

    public void writeNumber(BigDecimal v) {
        if (v == null) {
            this.writeNull();
        } else {
            this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        }
    }

    public void writeNumber(BigInteger v) {
        if (v == null) {
            this.writeNull();
        } else {
            this._tokenWriteContext.writeNumber(this._nodeFactory.numberNode(v));
        }
    }

    public void writeNumber(String encodedValue) {
        this.writeString(encodedValue);
    }

    public void writeBoolean(boolean state) {
        this._tokenWriteContext.writeBoolean(state);
    }

    public void writeNull() {
        this._tokenWriteContext.writeNull();
    }

    public void writePOJO(Object value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        Class<?> raw = value.getClass();
        if (raw == byte[].class || value instanceof RawValue) {
            this._tokenWriteContext.writePOJO(value);
            return;
        }
        this._objectWriteContext.writeValue((JsonGenerator)this, value);
    }

    public void writeTree(TreeNode node) {
        if (node == null) {
            this.writeNull();
            return;
        }
        if (node instanceof JsonNode) {
            this._tokenWriteContext.writeNode((JsonNode)node);
        } else {
            this._tokenWriteContext.writePOJO(node);
        }
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) {
        byte[] copy = Arrays.copyOfRange(data, offset, offset + len);
        this.writePOJO(copy);
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) {
        throw new UnsupportedOperationException();
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public void writeTypeId(Object id) {
        throw new UnsupportedOperationException();
    }

    public void writeObjectId(Object id) {
        throw new UnsupportedOperationException();
    }

    public void writeEmbeddedObject(Object object) {
        this._tokenWriteContext.writePOJO(object);
    }

    static final class ObjectContext
    extends TreeWriteContext {
        protected final ObjectNode _node;
        protected String _currentName;
        protected boolean _expectValue = false;

        protected ObjectContext(TreeWriteContext parent, JsonNodeFactory nf, Object currValue) {
            super(2, parent, nf, currValue);
            this._node = nf.objectNode();
        }

        @Override
        public final String currentName() {
            return this._currentName;
        }

        @Override
        public final TreeWriteContext createChildArrayContext(Object currValue) {
            this._verifyValueWrite();
            ArrayContext child = new ArrayContext(this, this._nodeFactory, currValue);
            this._node.set(this._currentName, child._node);
            return child;
        }

        @Override
        public TreeWriteContext createChildObjectContext(Object currValue) {
            this._verifyValueWrite();
            ObjectContext child = new ObjectContext(this, this._nodeFactory, currValue);
            this._node.set(this._currentName, child._node);
            return child;
        }

        @Override
        public boolean writeName(String name) {
            this._currentName = name;
            this._expectValue = true;
            return true;
        }

        @Override
        public void writeBinary(byte[] data) {
            this._verifyValueWrite();
            this._node.put(this._currentName, data);
        }

        @Override
        public void writeBoolean(boolean v) {
            this._verifyValueWrite();
            this._node.put(this._currentName, v);
        }

        @Override
        public void writeNull() {
            this._verifyValueWrite();
            this._node.putNull(this._currentName);
        }

        @Override
        public void writeNumber(ValueNode v) {
            this._verifyValueWrite();
            this._node.set(this._currentName, v);
        }

        @Override
        public void writeString(String v) {
            this._verifyValueWrite();
            this._node.put(this._currentName, v);
        }

        @Override
        public void writePOJO(Object v) {
            this._verifyValueWrite();
            this._node.putPOJO(this._currentName, v);
        }

        @Override
        public void writeNode(JsonNode node) {
            this._verifyValueWrite();
            this._node.set(this._currentName, node);
        }

        protected void _verifyValueWrite() {
            if (!this._expectValue) {
                throw new IllegalStateException("Expecting FIELD_NAME, not value");
            }
            this._expectValue = false;
        }
    }

    static final class ArrayContext
    extends TreeWriteContext {
        protected final ArrayNode _node;

        protected ArrayContext(TreeWriteContext parent, JsonNodeFactory nf, Object currValue) {
            super(1, parent, nf, currValue);
            this._node = nf.arrayNode();
        }

        @Override
        public final TreeWriteContext createChildArrayContext(Object currValue) {
            ArrayContext child = new ArrayContext(this, this._nodeFactory, currValue);
            this._node.add(child._node);
            return child;
        }

        @Override
        public TreeWriteContext createChildObjectContext(Object currValue) {
            ObjectContext child = new ObjectContext(this, this._nodeFactory, currValue);
            this._node.add(child._node);
            return child;
        }

        @Override
        public void writeBinary(byte[] v) {
            this._node.add(v);
        }

        @Override
        public void writeBoolean(boolean v) {
            this._node.add(v);
        }

        @Override
        public void writeNull() {
            this._node.addNull();
        }

        @Override
        public void writeNumber(ValueNode v) {
            this._node.add(v);
        }

        @Override
        public void writeString(String v) {
            this._node.add(v);
        }

        @Override
        public void writePOJO(Object value) {
            this._node.addPOJO(value);
        }

        @Override
        public void writeNode(JsonNode node) {
            this._node.add(node);
        }
    }

    static final class RootContext
    extends TreeWriteContext {
        protected JsonNode _node;

        public RootContext(JsonNodeFactory nf) {
            super(0, null, nf, null);
        }

        @Override
        public final TreeWriteContext createChildArrayContext(Object currValue) {
            ArrayContext child = new ArrayContext(this, this._nodeFactory, currValue);
            this._node = child._node;
            return child;
        }

        @Override
        public TreeWriteContext createChildObjectContext(Object currValue) {
            ObjectContext child = new ObjectContext(this, this._nodeFactory, currValue);
            this._node = child._node;
            return child;
        }

        @Override
        public void writeBinary(byte[] data) {
            this._node = this._nodeFactory.binaryNode(data);
        }

        @Override
        public void writeBoolean(boolean v) {
            this._node = this._nodeFactory.booleanNode(v);
        }

        @Override
        public void writeNull() {
            this._node = this._nodeFactory.nullNode();
        }

        @Override
        public void writeNumber(ValueNode v) {
            this._node = v;
        }

        @Override
        public void writeString(String v) {
            this._node = this._nodeFactory.textNode(v);
        }

        @Override
        public void writePOJO(Object value) {
            this._node = this._nodeFactory.pojoNode(value);
        }

        @Override
        public void writeNode(JsonNode node) {
            this._node = node;
        }
    }

    static abstract class TreeWriteContext
    extends TokenStreamContext {
        protected final TreeWriteContext _parent;
        protected final JsonNodeFactory _nodeFactory;
        protected Object _currentValue;

        protected TreeWriteContext(int type, TreeWriteContext parent, JsonNodeFactory nf, Object currValue) {
            this._type = type;
            this._parent = parent;
            this._nodeFactory = nf;
            this._currentValue = currValue;
        }

        public Object currentValue() {
            return this._currentValue;
        }

        public void assignCurrentValue(Object v) {
            this._currentValue = v;
        }

        public final TreeWriteContext getParent() {
            return this._parent;
        }

        public String currentName() {
            return null;
        }

        public abstract TreeWriteContext createChildArrayContext(Object var1);

        public abstract TreeWriteContext createChildObjectContext(Object var1);

        public boolean writeName(String name) {
            return false;
        }

        public abstract void writeBinary(byte[] var1);

        public abstract void writeBoolean(boolean var1);

        public abstract void writeNull();

        public abstract void writeNumber(ValueNode var1);

        public abstract void writeString(String var1);

        public abstract void writeNode(JsonNode var1);

        public abstract void writePOJO(Object var1);
    }
}

