/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> g) {
        this.generator = g;
    }

    public boolean writeAsReference(JsonGenerator g, SerializerProvider ctxt, ObjectIdWriter w) throws JacksonException {
        if (this.id != null && (this.idWritten || w.alwaysAsId)) {
            if (g.canWriteObjectId()) {
                g.writeObjectRef((Object)String.valueOf(this.id));
            } else {
                w.serializer.serialize(this.id, g, ctxt);
            }
            return true;
        }
        return false;
    }

    public Object generateId(Object forPojo) {
        if (this.id == null) {
            this.id = this.generator.generateId(forPojo);
        }
        return this.id;
    }

    public void writeAsDeclaration(JsonGenerator g, SerializerProvider ctxt, ObjectIdWriter w) throws JacksonException {
        this.idWritten = true;
        if (g.canWriteObjectId()) {
            String idStr = this.id == null ? null : String.valueOf(this.id);
            g.writeObjectId((Object)idStr);
            return;
        }
        SerializableString name = w.propertyName;
        if (name != null) {
            g.writeName(name);
            w.serializer.serialize(this.id, g, ctxt);
        }
    }
}

