/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.bean;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.bean.BeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.bean.BeanSerializerBase;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.Set;

public class UnrolledBeanAsArraySerializer
extends BeanSerializerBase {
    protected final BeanSerializerBase _defaultSerializer;
    public static final int MAX_PROPS = 6;
    protected final int _propCount;
    protected BeanPropertyWriter _prop1;
    protected BeanPropertyWriter _prop2;
    protected BeanPropertyWriter _prop3;
    protected BeanPropertyWriter _prop4;
    protected BeanPropertyWriter _prop5;
    protected BeanPropertyWriter _prop6;

    public UnrolledBeanAsArraySerializer(BeanSerializerBase src) {
        super(src, (ObjectIdWriter)null);
        this._defaultSerializer = src;
        this._propCount = this._props.length;
        this._calcUnrolled();
    }

    protected UnrolledBeanAsArraySerializer(BeanSerializerBase src, Set<String> toIgnore, Set<String> toInclude) {
        super(src, toIgnore, toInclude);
        this._defaultSerializer = src;
        this._propCount = this._props.length;
        this._calcUnrolled();
    }

    private void _calcUnrolled() {
        BeanPropertyWriter[] oProps = new BeanPropertyWriter[6];
        int offset = 6 - this._propCount;
        System.arraycopy(this._props, 0, oProps, offset, this._propCount);
        this._prop1 = oProps[0];
        this._prop2 = oProps[1];
        this._prop3 = oProps[2];
        this._prop4 = oProps[3];
        this._prop5 = oProps[4];
        this._prop6 = oProps[5];
    }

    public static UnrolledBeanAsArraySerializer tryConstruct(BeanSerializerBase src) {
        if (src.propertyCount() > 6 || src.getFilterId() != null || src.hasViewProperties()) {
            return null;
        }
        return new UnrolledBeanAsArraySerializer(src);
    }

    @Override
    public ValueSerializer<Object> unwrappingSerializer(NameTransformer transformer) {
        return this._defaultSerializer.unwrappingSerializer(transformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanAsArraySerializer(this._defaultSerializer, this._objectIdWriter, filterId);
    }

    @Override
    protected UnrolledBeanAsArraySerializer withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return new UnrolledBeanAsArraySerializer((BeanSerializerBase)this, toIgnore, toInclude);
    }

    @Override
    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return this;
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public void resolve(SerializerProvider provider) {
        super.resolve(provider);
        this._calcUnrolled();
    }

    @Override
    public void serializeWithType(Object bean, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = this._typeIdDef(typeSer, bean, JsonToken.START_ARRAY);
        typeSer.writeTypePrefix(gen, ctxt, typeIdDef);
        this.serializeNonFiltered(bean, gen, ctxt);
        typeSer.writeTypeSuffix(gen, ctxt, typeIdDef);
    }

    @Override
    public final void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws JacksonException {
        if (provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(provider)) {
            this.serializeNonFiltered(bean, gen, provider);
            return;
        }
        gen.writeStartArray(bean, this._props.length);
        this.serializeNonFiltered(bean, gen, provider);
        gen.writeEndArray();
    }

    private boolean hasSingleElement(SerializerProvider provider) {
        return this._props.length == 1;
    }

    protected final void serializeNonFiltered(Object bean, JsonGenerator gen, SerializerProvider provider) throws JacksonException {
        BeanPropertyWriter prop = null;
        try {
            switch (this._propCount) {
                default: {
                    prop = this._prop1;
                    prop.serializeAsElement(bean, gen, provider);
                }
                case 5: {
                    prop = this._prop2;
                    prop.serializeAsElement(bean, gen, provider);
                }
                case 4: {
                    prop = this._prop3;
                    prop.serializeAsElement(bean, gen, provider);
                }
                case 3: {
                    prop = this._prop4;
                    prop.serializeAsElement(bean, gen, provider);
                }
                case 2: {
                    prop = this._prop5;
                    prop.serializeAsElement(bean, gen, provider);
                }
                case 1: {
                    prop = this._prop6;
                    prop.serializeAsElement(bean, gen, provider);
                }
                case 0: 
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, bean, prop.getName());
        }
        catch (StackOverflowError e) {
            throw DatabindException.from(gen, "Infinite recursion (StackOverflowError)", (Throwable)e).prependPath(bean, prop.getName());
        }
    }
}

