/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.ser.SerializerCache;
import com.fasterxml.jackson.databind.util.SimpleLookupCache;
import com.fasterxml.jackson.databind.util.TypeKey;

public final class ReadOnlyClassToSerializerMap {
    private final SerializerCache _sharedCache;
    private final Bucket[] _buckets;
    private final int _size;
    private final int _mask;

    protected ReadOnlyClassToSerializerMap(SerializerCache shared, SimpleLookupCache<TypeKey, ValueSerializer<Object>> src) {
        this._sharedCache = shared;
        this._size = ReadOnlyClassToSerializerMap.findSize(src.size());
        this._mask = this._size - 1;
        Bucket[] buckets = new Bucket[this._size];
        src.contents((key, value) -> {
            int index = key.hashCode() & this._mask;
            buckets[index] = new Bucket(buckets[index], (TypeKey)key, (ValueSerializer<Object>)value);
        });
        this._buckets = buckets;
    }

    private static final int findSize(int size) {
        int result;
        int needed = size <= 64 ? size + size : size + (size >> 2);
        for (result = 8; result < needed; result += result) {
        }
        return result;
    }

    public static ReadOnlyClassToSerializerMap from(SerializerCache shared, SimpleLookupCache<TypeKey, ValueSerializer<Object>> src) {
        return new ReadOnlyClassToSerializerMap(shared, src);
    }

    public int size() {
        return this._size;
    }

    public ValueSerializer<Object> typedValueSerializer(JavaType type) {
        Bucket bucket = this._buckets[TypeKey.typedHash(type) & this._mask];
        if (bucket != null) {
            if (bucket.matchesTyped(type)) {
                return bucket.value;
            }
            while ((bucket = bucket.next) != null) {
                if (!bucket.matchesTyped(type)) continue;
                return bucket.value;
            }
        }
        return this._sharedCache.typedValueSerializer(type);
    }

    public ValueSerializer<Object> typedValueSerializer(Class<?> rawType) {
        Bucket bucket = this._buckets[TypeKey.typedHash(rawType) & this._mask];
        if (bucket != null) {
            if (bucket.matchesTyped(rawType)) {
                return bucket.value;
            }
            while ((bucket = bucket.next) != null) {
                if (!bucket.matchesTyped(rawType)) continue;
                return bucket.value;
            }
        }
        return this._sharedCache.typedValueSerializer(rawType);
    }

    public ValueSerializer<Object> untypedValueSerializer(JavaType type) {
        Bucket bucket = this._buckets[TypeKey.untypedHash(type) & this._mask];
        if (bucket != null) {
            if (bucket.matchesUntyped(type)) {
                return bucket.value;
            }
            while ((bucket = bucket.next) != null) {
                if (!bucket.matchesUntyped(type)) continue;
                return bucket.value;
            }
        }
        return this._sharedCache.untypedValueSerializer(type);
    }

    public ValueSerializer<Object> untypedValueSerializer(Class<?> rawType) {
        Bucket bucket = this._buckets[TypeKey.untypedHash(rawType) & this._mask];
        if (bucket != null) {
            if (bucket.matchesUntyped(rawType)) {
                return bucket.value;
            }
            while ((bucket = bucket.next) != null) {
                if (!bucket.matchesUntyped(rawType)) continue;
                return bucket.value;
            }
        }
        return this._sharedCache.untypedValueSerializer(rawType);
    }

    private static final class Bucket {
        public final ValueSerializer<Object> value;
        public final Bucket next;
        protected final Class<?> _class;
        protected final JavaType _type;
        protected final boolean _isTyped;

        public Bucket(Bucket next, TypeKey key, ValueSerializer<Object> value) {
            this.next = next;
            this.value = value;
            this._isTyped = key.isTyped();
            this._class = key.getRawType();
            this._type = key.getType();
        }

        public boolean matchesTyped(Class<?> key) {
            return this._class == key && this._isTyped;
        }

        public boolean matchesUntyped(Class<?> key) {
            return this._class == key && !this._isTyped;
        }

        public boolean matchesTyped(JavaType key) {
            return this._isTyped && key.equals(this._type);
        }

        public boolean matchesUntyped(JavaType key) {
            return !this._isTyped && key.equals(this._type);
        }
    }
}

