/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdDynamicSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;

@JacksonStdImpl
public class JsonValueSerializer
extends StdDynamicSerializer<Object> {
    protected final AnnotatedMember _accessor;
    protected final JavaType _valueType;
    protected final boolean _staticTyping;
    protected final boolean _forceTypeInformation;

    public JsonValueSerializer(JavaType nominalType, JavaType valueType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> ser, AnnotatedMember accessor) {
        super(nominalType, null, vts, ser);
        this._valueType = valueType;
        this._staticTyping = staticTyping;
        this._accessor = accessor;
        this._forceTypeInformation = true;
    }

    protected JsonValueSerializer(JsonValueSerializer src, BeanProperty property, TypeSerializer vts, ValueSerializer<?> ser, boolean forceTypeInfo) {
        super(src, property, vts, ser);
        this._valueType = src._valueType;
        this._accessor = src._accessor;
        this._staticTyping = src._staticTyping;
        this._forceTypeInformation = forceTypeInfo;
    }

    public JsonValueSerializer withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> ser, boolean forceTypeInfo) {
        if (this._property == property && this._valueTypeSerializer == vts && this._valueSerializer == ser && forceTypeInfo == this._forceTypeInformation) {
            return this;
        }
        return new JsonValueSerializer(this, property, vts, ser, forceTypeInfo);
    }

    @Override
    public boolean isEmpty(SerializerProvider ctxt, Object bean) {
        Object referenced = this._accessor.getValue(bean);
        if (referenced == null) {
            return true;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findAndAddDynamic(ctxt, referenced.getClass());
        }
        return ser.isEmpty(ctxt, referenced);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property) {
        ValueSerializer<Object> ser;
        TypeSerializer vts = this._valueTypeSerializer;
        if (vts != null) {
            vts = vts.forProperty(ctxt, property);
        }
        if ((ser = this._valueSerializer) == null) {
            if (this._staticTyping || ctxt.isEnabled(MapperFeature.USE_STATIC_TYPING) || this._valueType.isFinal()) {
                ser = ctxt.findPrimaryPropertySerializer(this._valueType, property);
                boolean forceTypeInformation = this.isNaturalTypeWithStdHandling(this._valueType.getRawClass(), ser);
                return this.withResolved(property, vts, ser, forceTypeInformation);
            }
            if (property != this._property) {
                return this.withResolved(property, vts, ser, this._forceTypeInformation);
            }
        } else {
            ser = ctxt.handlePrimaryContextualization(ser, property);
            return this.withResolved(property, vts, ser, this._forceTypeInformation);
        }
        return this;
    }

    @Override
    public void serialize(Object bean, JsonGenerator gen, SerializerProvider ctxt) throws JacksonException {
        Object value;
        try {
            value = this._accessor.getValue(bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, bean, this._accessor.getName() + "()");
            return;
        }
        if (value == null) {
            ctxt.defaultSerializeNullValue(gen);
            return;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            Class<?> cc = value.getClass();
            ser = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._valueType, cc)) : this._findAndAddDynamic(ctxt, cc);
        }
        if (this._valueTypeSerializer != null) {
            ser.serializeWithType(value, gen, ctxt, this._valueTypeSerializer);
        } else {
            ser.serialize(value, gen, ctxt);
        }
    }

    @Override
    public void serializeWithType(Object bean, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer0) throws JacksonException {
        Object value;
        try {
            value = this._accessor.getValue(bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, bean, this._accessor.getName() + "()");
            return;
        }
        if (value == null) {
            ctxt.defaultSerializeNullValue(gen);
            return;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            Class<?> cc = value.getClass();
            ser = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._valueType, cc)) : this._findAndAddDynamic(ctxt, cc);
        }
        if (this._forceTypeInformation) {
            WritableTypeId typeIdDef = typeSer0.writeTypePrefix(gen, ctxt, typeSer0.typeId(bean, JsonToken.VALUE_STRING));
            ser.serialize(value, gen, ctxt);
            typeSer0.writeTypeSuffix(gen, ctxt, typeIdDef);
            return;
        }
        TypeSerializerRerouter rr = new TypeSerializerRerouter(typeSer0, bean);
        ser.serializeWithType(value, gen, ctxt, rr);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JavaType type = this._accessor.getType();
        Class<?> declaring = this._accessor.getDeclaringClass();
        if (declaring != null && ClassUtil.isEnumType(declaring) && this._acceptJsonFormatVisitorForEnum(visitor, typeHint, declaring)) {
            return;
        }
        ValueSerializer<Object> ser = this._valueSerializer;
        if (ser == null && (ser = visitor.getProvider().findPrimaryPropertySerializer(type, this._property)) == null) {
            visitor.expectAnyFormat(typeHint);
            return;
        }
        ser.acceptJsonFormatVisitor(visitor, type);
    }

    protected boolean _acceptJsonFormatVisitorForEnum(JsonFormatVisitorWrapper visitor, JavaType typeHint, Class<?> enumType) {
        JsonStringFormatVisitor stringVisitor = visitor.expectStringFormat(typeHint);
        if (stringVisitor != null) {
            LinkedHashSet<String> enums = new LinkedHashSet<String>();
            for (Object en : enumType.getEnumConstants()) {
                try {
                    enums.add(String.valueOf(this._accessor.getValue(en)));
                }
                catch (Exception e) {
                    Throwable t = e;
                    while (t instanceof InvocationTargetException && t.getCause() != null) {
                        t = t.getCause();
                    }
                    ClassUtil.throwIfError(t);
                    throw DatabindException.wrapWithPath(t, en, this._accessor.getName() + "()");
                }
            }
            stringVisitor.enumTypes(enums);
        }
        return true;
    }

    protected boolean isNaturalTypeWithStdHandling(Class<?> rawType, ValueSerializer<?> ser) {
        if (rawType.isPrimitive() ? rawType != Integer.TYPE && rawType != Boolean.TYPE && rawType != Double.TYPE : rawType != String.class && rawType != Integer.class && rawType != Boolean.class && rawType != Double.class) {
            return false;
        }
        return this.isDefaultSerializer(ser);
    }

    static class TypeSerializerRerouter
    extends TypeSerializer {
        protected final TypeSerializer _typeSerializer;
        protected final Object _forObject;

        public TypeSerializerRerouter(TypeSerializer ts, Object ob) {
            this._typeSerializer = ts;
            this._forObject = ob;
        }

        @Override
        public TypeSerializer forProperty(SerializerProvider ctxt, BeanProperty prop) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonTypeInfo.As getTypeInclusion() {
            return this._typeSerializer.getTypeInclusion();
        }

        @Override
        public String getPropertyName() {
            return this._typeSerializer.getPropertyName();
        }

        @Override
        public TypeIdResolver getTypeIdResolver() {
            return this._typeSerializer.getTypeIdResolver();
        }

        @Override
        public WritableTypeId writeTypePrefix(JsonGenerator g, SerializerProvider ctxt, WritableTypeId typeId) throws JacksonException {
            typeId.forValue = this._forObject;
            return this._typeSerializer.writeTypePrefix(g, ctxt, typeId);
        }

        @Override
        public WritableTypeId writeTypeSuffix(JsonGenerator g, SerializerProvider ctxt, WritableTypeId typeId) throws JacksonException {
            return this._typeSerializer.writeTypeSuffix(g, ctxt, typeId);
        }
    }
}

