/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object> {
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) {
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format != null) {
            JsonFormat.Shape shape = format.getShape();
            if (shape.isNumeric()) {
                return new AsNumber(this._forPrimitive);
            }
            if (shape == JsonFormat.Shape.STRING) {
                return new ToStringSerializer(this._handledType);
            }
        }
        return this;
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializerProvider provider) throws JacksonException {
        g.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws JacksonException {
        g.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectBooleanFormat(typeHint);
    }

    static final class AsNumber
    extends StdScalarSerializer<Object> {
        protected final boolean _forPrimitive;

        public AsNumber(boolean forPrimitive) {
            super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
            this._forPrimitive = forPrimitive;
        }

        @Override
        public ValueSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) {
            JsonFormat.Shape shape;
            JsonFormat.Value format = this.findFormatOverrides(serializers, property, Boolean.class);
            if (format != null && !(shape = format.getShape()).isNumeric()) {
                return new BooleanSerializer(this._forPrimitive);
            }
            return this;
        }

        @Override
        public void serialize(Object value, JsonGenerator g, SerializerProvider provider) throws JacksonException {
            g.writeNumber(Boolean.FALSE.equals(value) ? 0 : 1);
        }

        @Override
        public final void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws JacksonException {
            g.writeBoolean(Boolean.TRUE.equals(value));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
        }
    }
}

