/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.jdk;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.jdk.DateTimeSerializerBase;
import java.text.DateFormat;
import java.util.Calendar;

@JacksonStdImpl
public class JavaUtilCalendarSerializer
extends DateTimeSerializerBase<Calendar> {
    public static final JavaUtilCalendarSerializer instance = new JavaUtilCalendarSerializer();

    public JavaUtilCalendarSerializer() {
        this(null, null);
    }

    public JavaUtilCalendarSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(Calendar.class, useTimestamp, customFormat);
    }

    public JavaUtilCalendarSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new JavaUtilCalendarSerializer(timestamp, customFormat);
    }

    @Override
    protected long _timestamp(Calendar value) {
        return value == null ? 0L : value.getTimeInMillis();
    }

    @Override
    public void serialize(Calendar value, JsonGenerator g, SerializerProvider provider) throws JacksonException {
        if (this._asTimestamp(provider)) {
            g.writeNumber(this._timestamp(value));
            return;
        }
        this._serializeAsString(value.getTime(), g, provider);
    }
}

