/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.jdk;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.jdk.DateTimeSerializerBase;
import java.text.DateFormat;
import java.util.Date;

@JacksonStdImpl
public class JavaUtilDateSerializer
extends DateTimeSerializerBase<Date> {
    public static final JavaUtilDateSerializer instance = new JavaUtilDateSerializer();

    public JavaUtilDateSerializer() {
        this(null, null);
    }

    public JavaUtilDateSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(Date.class, useTimestamp, customFormat);
    }

    public JavaUtilDateSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new JavaUtilDateSerializer(timestamp, customFormat);
    }

    @Override
    protected long _timestamp(Date value) {
        return value == null ? 0L : value.getTime();
    }

    @Override
    public void serialize(Date value, JsonGenerator g, SerializerProvider provider) throws JacksonException {
        if (this._asTimestamp(provider)) {
            g.writeNumber(this._timestamp(value));
            return;
        }
        this._serializeAsString(value, g, provider);
    }
}

