/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

public abstract class StdContainerSerializer<T>
extends StdSerializer<T> {
    protected final BeanProperty _property;
    protected PropertySerializerMap _dynamicValueSerializers;

    protected StdContainerSerializer(Class<?> t) {
        this(t, null);
    }

    protected StdContainerSerializer(Class<?> t, BeanProperty prop) {
        super(t);
        this._property = prop;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected StdContainerSerializer(JavaType fullType, BeanProperty prop) {
        super(fullType);
        this._property = prop;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected StdContainerSerializer(StdContainerSerializer<?> src) {
        this(src, src._property);
    }

    protected StdContainerSerializer(StdContainerSerializer<?> src, BeanProperty prop) {
        super(src._handledType);
        this._property = prop;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    public StdContainerSerializer<?> withValueTypeSerializer(TypeSerializer vts) {
        if (vts == null) {
            return this;
        }
        return this._withValueTypeSerializer(vts);
    }

    public abstract JavaType getContentType();

    public abstract ValueSerializer<?> getContentSerializer();

    @Override
    public abstract boolean isEmpty(SerializerProvider var1, T var2);

    public abstract boolean hasSingleElement(T var1);

    protected abstract StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer var1);

    protected ValueSerializer<Object> _findAndAddDynamic(SerializerProvider ctxt, Class<?> type) {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected ValueSerializer<Object> _findAndAddDynamic(SerializerProvider ctxt, JavaType type) {
        PropertySerializerMap map = this._dynamicValueSerializers;
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, ctxt, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

