/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;

public class StdDelegatingSerializer
extends StdSerializer<Object> {
    protected final BeanProperty _property;
    protected final Converter<Object, ?> _converter;
    protected final JavaType _delegateType;
    protected final ValueSerializer<Object> _delegateSerializer;
    protected PropertySerializerMap _dynamicValueSerializers = PropertySerializerMap.emptyForProperties();

    public StdDelegatingSerializer(Converter<?, ?> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
        this._property = null;
    }

    public <T> StdDelegatingSerializer(Class<T> cls, Converter<T, ?> converter) {
        super(cls);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
        this._property = null;
    }

    public StdDelegatingSerializer(Converter<Object, ?> converter, JavaType delegateType, ValueSerializer<?> delegateSerializer, BeanProperty prop) {
        super(delegateType);
        this._converter = converter;
        this._delegateType = delegateType;
        this._delegateSerializer = delegateSerializer;
        this._property = prop;
    }

    protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType delegateType, ValueSerializer<?> delegateSerializer, BeanProperty prop) {
        ClassUtil.verifyMustOverride(StdDelegatingSerializer.class, this, "withDelegate");
        return new StdDelegatingSerializer(converter, delegateType, delegateSerializer, prop);
    }

    @Override
    public void resolve(SerializerProvider ctxt) {
        if (this._delegateSerializer != null) {
            this._delegateSerializer.resolve(ctxt);
        }
    }

    @Override
    public ValueSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property) {
        ValueSerializer<Object> delSer = this._delegateSerializer;
        JavaType delegateType = this._delegateType;
        if (delSer == null) {
            if (delegateType == null) {
                delegateType = this._converter.getOutputType(ctxt.getTypeFactory());
            }
            if (!delegateType.isJavaLangObject()) {
                delSer = ctxt.findValueSerializer(delegateType);
            }
        }
        if (delSer != null) {
            delSer = ctxt.handleSecondaryContextualization(delSer, property);
        }
        if (delSer == this._delegateSerializer && delegateType == this._delegateType && property == this._property) {
            return this;
        }
        return this.withDelegate(this._converter, delegateType, delSer, property);
    }

    protected Converter<Object, ?> getConverter() {
        return this._converter;
    }

    @Override
    public ValueSerializer<?> getDelegatee() {
        return this._delegateSerializer;
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws JacksonException {
        Object delegateValue = this.convertValue(value);
        if (delegateValue == null) {
            ctxt.defaultSerializeNullValue(gen);
            return;
        }
        ValueSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(delegateValue, ctxt);
        }
        ser.serialize(delegateValue, gen, ctxt);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws JacksonException {
        Object delegateValue = this.convertValue(value);
        ValueSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(value, ctxt);
        }
        ser.serializeWithType(delegateValue, gen, ctxt, typeSer);
    }

    @Override
    public boolean isEmpty(SerializerProvider ctxt, Object value) {
        Object delegateValue = this.convertValue(value);
        if (delegateValue == null) {
            return true;
        }
        ValueSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(value, ctxt);
        }
        return ser.isEmpty(ctxt, delegateValue);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        if (this._delegateSerializer != null) {
            this._delegateSerializer.acceptJsonFormatVisitor(visitor, typeHint);
        }
    }

    protected Object convertValue(Object value) {
        return this._converter.convert(value);
    }

    protected ValueSerializer<Object> _findSerializer(Object value, SerializerProvider ctxt) {
        Class<?> cc = value.getClass();
        PropertySerializerMap.SerializerAndMapResult result = this._dynamicValueSerializers.findAndAddSecondarySerializer(cc, ctxt, this._property);
        if (this._dynamicValueSerializers != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

