/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DatabindException
extends JacksonException {
    private static final long serialVersionUID = 3L;
    static final int MAX_REFS_TO_LIST = 1000;
    protected LinkedList<Reference> _path;
    protected transient Closeable _processor;

    protected DatabindException(Closeable processor, String msg) {
        super(msg);
        this._processor = processor;
        if (processor instanceof JsonParser) {
            this._location = ((JsonParser)processor).currentTokenLocation();
        }
    }

    protected DatabindException(Closeable processor, String msg, Throwable problem) {
        super(msg, problem);
        this._processor = processor;
        if (problem instanceof JacksonException) {
            this._location = ((JacksonException)problem).getLocation();
        } else if (processor instanceof JsonParser) {
            this._location = ((JsonParser)processor).currentTokenLocation();
        }
    }

    protected DatabindException(Closeable processor, String msg, JsonLocation loc) {
        super(msg, loc, null);
        this._processor = processor;
        this._location = loc;
    }

    protected DatabindException(String msg, JsonLocation loc, Throwable rootCause) {
        super(msg, loc, rootCause);
    }

    protected DatabindException(String msg) {
        super(msg);
    }

    protected DatabindException(String msg, JsonLocation loc) {
        this(msg, loc, null);
    }

    protected DatabindException(String msg, Throwable rootCause) {
        this(msg, null, rootCause);
    }

    public static DatabindException from(JsonParser p, String msg) {
        return new DatabindException((Closeable)p, msg);
    }

    public static DatabindException from(JsonParser p, String msg, Throwable problem) {
        return new DatabindException((Closeable)p, msg, problem);
    }

    public static DatabindException from(JsonGenerator g, String msg) {
        return new DatabindException((Closeable)g, msg, (Throwable)null);
    }

    public static DatabindException from(JsonGenerator g, String msg, Throwable problem) {
        return new DatabindException((Closeable)g, msg, problem);
    }

    public static DatabindException from(DeserializationContext ctxt, String msg) {
        return new DatabindException((Closeable)ctxt.getParser(), msg);
    }

    public static DatabindException from(DeserializationContext ctxt, String msg, Throwable t) {
        return new DatabindException((Closeable)ctxt.getParser(), msg, t);
    }

    public static DatabindException from(SerializerProvider ctxt, String msg) {
        return new DatabindException((Closeable)ctxt.getGenerator(), msg);
    }

    public static DatabindException from(SerializerProvider ctxt, String msg, Throwable problem) {
        return new DatabindException((Closeable)ctxt.getGenerator(), msg, problem);
    }

    public static DatabindException wrapWithPath(Throwable src, Object refFrom, String refPropertyName) {
        return DatabindException.wrapWithPath(src, new Reference(refFrom, refPropertyName));
    }

    public static DatabindException wrapWithPath(Throwable src, Object refFrom, int index) {
        return DatabindException.wrapWithPath(src, new Reference(refFrom, index));
    }

    public static DatabindException wrapWithPath(Throwable src, Reference ref) {
        DatabindException jme;
        if (src instanceof DatabindException) {
            jme = (DatabindException)((Object)src);
        } else {
            Object proc0;
            String msg = ClassUtil.exceptionMessage(src);
            if (msg == null || msg.isEmpty()) {
                msg = "(was " + src.getClass().getName() + ")";
            }
            Closeable proc = null;
            if (src instanceof JacksonException && (proc0 = ((JacksonException)src).processor()) instanceof Closeable) {
                proc = (Closeable)proc0;
            }
            jme = new DatabindException(proc, msg, src);
        }
        jme.prependPath(ref);
        return jme;
    }

    public DatabindException prependPath(Object referrer, String propertyName) {
        return this.prependPath(new Reference(referrer, propertyName));
    }

    public DatabindException prependPath(Object referrer, int index) {
        return this.prependPath(new Reference(referrer, index));
    }

    public DatabindException prependPath(Reference r) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 1000) {
            this._path.addFirst(r);
        }
        return this;
    }

    public List<Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder sb) {
        this._appendPathDesc(sb);
        return sb;
    }

    public Object processor() {
        return this._processor;
    }

    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    public String getMessage() {
        return this._buildMessage();
    }

    protected String _buildMessage() {
        String msg = super.getMessage();
        if (this._path == null) {
            return msg;
        }
        StringBuilder sb = msg == null ? new StringBuilder() : new StringBuilder(msg);
        sb.append(" (through reference chain: ");
        sb = this.getPathReference(sb);
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ": " + this.getMessage();
    }

    protected void _appendPathDesc(StringBuilder sb) {
        if (this._path == null) {
            return;
        }
        Iterator it = this._path.iterator();
        while (it.hasNext()) {
            sb.append(((Reference)it.next()).toString());
            if (!it.hasNext()) continue;
            sb.append("->");
        }
    }

    public static class Reference
    implements Serializable {
        private static final long serialVersionUID = 3L;
        protected transient Object _from;
        protected String _propertyName;
        protected int _index = -1;
        protected String _desc;

        protected Reference() {
        }

        public Reference(Object from) {
            this._from = from;
        }

        public Reference(Object from, String propertyName) {
            this._from = from;
            if (propertyName == null) {
                throw new NullPointerException("Cannot pass null 'propertyName'");
            }
            this._propertyName = propertyName;
        }

        public Reference(Object from, int index) {
            this._from = from;
            this._index = index;
        }

        void setPropertyName(String n) {
            this._propertyName = n;
        }

        void setIndex(int ix) {
            this._index = ix;
        }

        void setDescription(String d) {
            this._desc = d;
        }

        public Object from() {
            return this._from;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public int getIndex() {
            return this._index;
        }

        public String getDescription() {
            if (this._desc == null) {
                StringBuilder sb = new StringBuilder();
                if (this._from == null) {
                    sb.append("UNKNOWN");
                } else {
                    Class<?> cls = this._from instanceof Class ? (Class<?>)this._from : this._from.getClass();
                    int arrays = 0;
                    while (cls.isArray()) {
                        cls = cls.getComponentType();
                        ++arrays;
                    }
                    sb.append(cls.getName());
                    while (--arrays >= 0) {
                        sb.append("[]");
                    }
                }
                sb.append('[');
                if (this._propertyName != null) {
                    sb.append('\"');
                    sb.append(this._propertyName);
                    sb.append('\"');
                } else if (this._index >= 0) {
                    sb.append(this._index);
                } else {
                    sb.append('?');
                }
                sb.append(']');
                this._desc = sb.toString();
            }
            return this._desc;
        }

        public String toString() {
            return this.getDescription();
        }

        Object writeReplace() {
            this.getDescription();
            return this;
        }
    }
}

