/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectReadContext;
import com.fasterxml.jackson.core.ObjectWriteContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.exc.WrappedIOException;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.json.JsonFactory;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.Snapshottable;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JacksonModule;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.cfg.CoercionConfigs;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DeserializationContexts;
import com.fasterxml.jackson.databind.cfg.GeneratorSettings;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.cfg.MapperBuilderState;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.cfg.SerializationContexts;
import com.fasterxml.jackson.databind.deser.DeserializationContextExt;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.MixInHandler;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializationContextExt;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectMapper
implements TreeCodec,
Versioned,
Serializable {
    private static final long serialVersionUID = 3L;
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected final TokenStreamFactory _streamFactory;
    protected final TypeFactory _typeFactory;
    protected final InjectableValues _injectableValues;
    protected final SerializationContexts _serializationContexts;
    protected final SerializationConfig _serializationConfig;
    protected final DeserializationContexts _deserializationContexts;
    protected final DeserializationConfig _deserializationConfig;
    protected final ConcurrentHashMap<JavaType, ValueDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);
    protected final MapperBuilderState _savedBuilderState;

    public ObjectMapper() {
        this(new PrivateBuilder((TokenStreamFactory)new JsonFactory()));
    }

    public ObjectMapper(TokenStreamFactory streamFactory) {
        this(new PrivateBuilder(streamFactory));
    }

    protected ObjectMapper(MapperBuilder<?, ?> builder) {
        this._savedBuilderState = builder.saveStateApplyModules();
        this._streamFactory = builder.streamFactory();
        AtomicReference ref = new AtomicReference();
        builder.withAllConfigOverrides(overrides -> ref.set(overrides));
        ConfigOverrides configOverrides = (ConfigOverrides)Snapshottable.takeSnapshot((Snapshottable)((Snapshottable)ref.get()));
        AtomicReference ref2 = new AtomicReference();
        builder.withAllCoercionConfigs(overrides -> ref2.set(overrides));
        CoercionConfigs coercionConfigs = (CoercionConfigs)Snapshottable.takeSnapshot((Snapshottable)((Snapshottable)ref2.get()));
        this._typeFactory = (TypeFactory)Snapshottable.takeSnapshot((Snapshottable)builder.typeFactory());
        ClassIntrospector classIntr = builder.classIntrospector().forMapper();
        SubtypeResolver subtypeResolver = (SubtypeResolver)Snapshottable.takeSnapshot((Snapshottable)builder.subtypeResolver());
        MixInHandler mixIns = (MixInHandler)Snapshottable.takeSnapshot((Snapshottable)builder.mixInHandler());
        this._serializationContexts = builder.serializationContexts().forMapper(this, this._streamFactory, builder.serializerFactory());
        this._deserializationContexts = builder.deserializationContexts().forMapper(this, this._streamFactory, builder.deserializerFactory());
        this._injectableValues = (InjectableValues)Snapshottable.takeSnapshot((Snapshottable)builder.injectableValues());
        RootNameLookup rootNames = new RootNameLookup();
        FilterProvider filterProvider = (FilterProvider)Snapshottable.takeSnapshot((Snapshottable)builder.filterProvider());
        this._deserializationConfig = builder.buildDeserializationConfig(configOverrides, mixIns, this._typeFactory, classIntr, subtypeResolver, rootNames, coercionConfigs);
        this._serializationConfig = builder.buildSerializationConfig(configOverrides, mixIns, this._typeFactory, classIntr, subtypeResolver, rootNames, filterProvider);
    }

    public <M extends ObjectMapper, B extends MapperBuilder<M, B>> MapperBuilder<M, B> rebuild() {
        ClassUtil.verifyMustOverride(ObjectMapper.class, this, "rebuild");
        return new PrivateBuilder(this._savedBuilderState);
    }

    protected Object writeReplace() {
        return this._savedBuilderState;
    }

    protected Object readResolve() {
        throw new IllegalStateException("Should never deserialize `" + this.getClass().getName() + "` directly");
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public SerializationConfig serializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig deserializationConfig() {
        return this._deserializationConfig;
    }

    public TokenStreamFactory tokenStreamFactory() {
        return this._streamFactory;
    }

    public JsonNodeFactory getNodeFactory() {
        return this._deserializationConfig.getNodeFactory();
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    public JavaType constructType(Type type) {
        this._assertNotNull("type", type);
        return this._typeFactory.constructType(type);
    }

    public JavaType constructType(TypeReference<?> typeReference) {
        this._assertNotNull("typeReference", typeReference);
        return this._typeFactory.constructType(typeReference);
    }

    public boolean isEnabled(TokenStreamFactory.Feature f) {
        return this._streamFactory.isEnabled(f);
    }

    public boolean isEnabled(StreamReadFeature f) {
        return this._deserializationConfig.isEnabled(f);
    }

    public boolean isEnabled(StreamWriteFeature f) {
        return this._serializationConfig.isEnabled(f);
    }

    public boolean isEnabled(MapperFeature f) {
        return this._serializationConfig.isEnabled(f);
    }

    public boolean isEnabled(DeserializationFeature f) {
        return this._deserializationConfig.isEnabled(f);
    }

    public boolean isEnabled(SerializationFeature f) {
        return this._serializationConfig.isEnabled(f);
    }

    public Collection<JacksonModule> getRegisteredModules() {
        return this._savedBuilderState.modules();
    }

    public JsonParser createParser(File src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(Path src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(URL src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public JsonParser createParser(InputStream in) throws JacksonException {
        this._assertNotNull("in", in);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, in));
    }

    public JsonParser createParser(Reader r) throws JacksonException {
        this._assertNotNull("r", r);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, r));
    }

    public JsonParser createParser(byte[] content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(byte[] content, int offset, int len) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content, offset, len));
    }

    public JsonParser createParser(String content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(char[] content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createParser(char[] content, int offset, int len) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content, offset, len));
    }

    public JsonParser createParser(DataInput content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonParser createNonBlockingByteArrayParser() throws JacksonException {
        DeserializationContextExt ctxt = this._deserializationContext();
        return ctxt.assignAndReturnParser(this._streamFactory.createNonBlockingByteArrayParser((ObjectReadContext)ctxt));
    }

    public JsonGenerator createGenerator(OutputStream out) throws JacksonException {
        this._assertNotNull("out", out);
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws JacksonException {
        this._assertNotNull("out", out);
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out, enc);
    }

    public JsonGenerator createGenerator(Writer w) throws JacksonException {
        this._assertNotNull("w", w);
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), w);
    }

    public JsonGenerator createGenerator(File f, JsonEncoding enc) throws JacksonException {
        this._assertNotNull("f", f);
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), f, enc);
    }

    public JsonGenerator createGenerator(Path path, JsonEncoding enc) throws JacksonException {
        this._assertNotNull("path", path);
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), path, enc);
    }

    public JsonGenerator createGenerator(DataOutput out) throws JacksonException {
        this._assertNotNull("out", out);
        return this._streamFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), out);
    }

    public ObjectNode createObjectNode() {
        return this._deserializationConfig.getNodeFactory().objectNode();
    }

    public ArrayNode createArrayNode() {
        return this._deserializationConfig.getNodeFactory().arrayNode();
    }

    public JsonNode booleanNode(boolean b) {
        return this._deserializationConfig.getNodeFactory().booleanNode(b);
    }

    public JsonNode stringNode(String text) {
        return this._deserializationConfig.getNodeFactory().textNode(text);
    }

    public JsonNode missingNode() {
        return this._deserializationConfig.getNodeFactory().missingNode();
    }

    public JsonNode nullNode() {
        return this._deserializationConfig.getNodeFactory().nullNode();
    }

    public JsonParser treeAsTokens(TreeNode n) {
        this._assertNotNull("n", n);
        DeserializationContextExt ctxt = this._deserializationContext();
        return new TreeTraversingParser((JsonNode)n, ctxt);
    }

    public JsonNode readTree(JsonParser p) throws JacksonException {
        this._assertNotNull("p", p);
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            return null;
        }
        JsonNode n = (JsonNode)this._readValue(this._deserializationContext(p), p, JSON_NODE_TYPE);
        if (n == null) {
            n = this.getNodeFactory().nullNode();
        }
        return n;
    }

    public void writeTree(JsonGenerator g, TreeNode rootNode) throws JacksonException {
        this._assertNotNull("g", g);
        SerializationConfig config = this.serializationConfig();
        this._serializerProvider(config).serializeValue(g, rootNode);
        if (config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            g.flush();
        }
    }

    public <T> T readValue(JsonParser p, Class<T> valueType) throws JacksonException {
        this._assertNotNull("p", p);
        return (T)this._readValue(this._deserializationContext(p), p, this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(JsonParser p, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("p", p);
        return (T)this._readValue(this._deserializationContext(p), p, this._typeFactory.constructType(valueTypeRef));
    }

    public final <T> T readValue(JsonParser p, ResolvedType valueType) throws JacksonException {
        this._assertNotNull("p", p);
        return (T)this._readValue(this._deserializationContext(p), p, (JavaType)valueType);
    }

    public <T> T readValue(JsonParser p, JavaType valueType) throws JacksonException {
        this._assertNotNull("p", p);
        return (T)this._readValue(this._deserializationContext(p), p, valueType);
    }

    public <T> MappingIterator<T> readValues(JsonParser p, JavaType valueType) throws JacksonException {
        this._assertNotNull("p", p);
        DeserializationContextExt ctxt = this._deserializationContext(p);
        ValueDeserializer<Object> deser = this._findRootDeserializer(ctxt, valueType);
        return new MappingIterator(valueType, p, ctxt, deser, false, null);
    }

    public <T> MappingIterator<T> readValues(JsonParser p, Class<T> valueType) throws JacksonException {
        this._assertNotNull("p", p);
        return this.readValues(p, this._typeFactory.constructType(valueType));
    }

    public <T> MappingIterator<T> readValues(JsonParser p, TypeReference<T> valueType) throws JacksonException {
        this._assertNotNull("p", p);
        return this.readValues(p, this._typeFactory.constructType(valueType));
    }

    public JsonNode readTree(InputStream in) throws JacksonException {
        this._assertNotNull("in", in);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, in));
    }

    public JsonNode readTree(Reader r) throws JacksonException {
        this._assertNotNull("r", r);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, r));
    }

    public JsonNode readTree(String content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonNode readTree(byte[] content) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content));
    }

    public JsonNode readTree(byte[] content, int offset, int len) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content, offset, len));
    }

    public JsonNode readTree(File file) throws JacksonException {
        this._assertNotNull("file", file);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, file));
    }

    public JsonNode readTree(Path path) throws JacksonException {
        this._assertNotNull("path", path);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, path));
    }

    public JsonNode readTree(URL src) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return this._readTreeAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src));
    }

    public void writeValue(JsonGenerator g, Object value) throws JacksonException {
        this._assertNotNull("g", g);
        SerializationConfig config = this.serializationConfig();
        if (config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseableValue(g, value, config);
        } else {
            this._serializerProvider(config).serializeValue(g, value);
            if (config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                g.flush();
            }
        }
    }

    public <T> T treeToValue(TreeNode n, Class<T> valueType) throws JacksonException {
        Object ob;
        if (n == null) {
            return null;
        }
        if (TreeNode.class.isAssignableFrom(valueType) && valueType.isAssignableFrom(n.getClass())) {
            return (T)n;
        }
        JsonToken tt = n.asToken();
        if (tt == JsonToken.VALUE_EMBEDDED_OBJECT && n instanceof POJONode && ((ob = ((POJONode)n).getPojo()) == null || valueType.isInstance(ob))) {
            return (T)ob;
        }
        return this.readValue(this.treeAsTokens(n), valueType);
    }

    public <T extends JsonNode> T valueToTree(Object fromValue) throws JacksonException {
        return this._serializerProvider().valueToTree(fromValue);
    }

    public <T> T readValue(File src, Class<T> valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(File src, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(File src, JavaType valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(Path src, Class<T> valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(Path src, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(Path src, JavaType valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(URL src, Class<T> valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(URL src, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(URL src, JavaType valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(String content, Class<T> valueType) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(String content, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(String content, JavaType valueType) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), valueType);
    }

    public <T> T readValue(Reader src, Class<T> valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(Reader src, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(Reader src, JavaType valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(InputStream src, Class<T> valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(InputStream src, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(InputStream src, JavaType valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(byte[] content, Class<T> valueType) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(byte[] content, int offset, int len, Class<T> valueType) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content, offset, len), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(byte[] content, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(byte[] content, int offset, int len, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content, offset, len), this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(byte[] content, JavaType valueType) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content), valueType);
    }

    public <T> T readValue(byte[] content, int offset, int len, JavaType valueType) throws JacksonException {
        this._assertNotNull("content", content);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, content, offset, len), valueType);
    }

    public <T> T readValue(DataInput src, Class<T> valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(DataInput src, JavaType valueType) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), valueType);
    }

    public <T> T readValue(DataInput src, TypeReference<T> valueTypeRef) throws JacksonException {
        this._assertNotNull("src", src);
        DeserializationContextExt ctxt = this._deserializationContext();
        return (T)this._readMapAndClose(ctxt, this._streamFactory.createParser((ObjectReadContext)ctxt, src), this._typeFactory.constructType(valueTypeRef));
    }

    public void writeValue(File file, Object value) throws JacksonException {
        this._assertNotNull("file", file);
        SerializationContextExt prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, file, JsonEncoding.UTF8), value);
    }

    public void writeValue(Path path, Object value) throws JacksonException {
        this._assertNotNull("path", path);
        SerializationContextExt prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, path, JsonEncoding.UTF8), value);
    }

    public void writeValue(OutputStream out, Object value) throws JacksonException {
        this._assertNotNull("out", out);
        SerializationContextExt prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, out, JsonEncoding.UTF8), value);
    }

    public void writeValue(DataOutput out, Object value) throws JacksonException {
        this._assertNotNull("out", out);
        SerializationContextExt prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, out), value);
    }

    public void writeValue(Writer w, Object value) throws JacksonException {
        this._assertNotNull("w", w);
        SerializationContextExt prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, w), value);
    }

    public String writeValueAsString(Object value) throws JacksonException {
        SegmentedStringWriter sw = new SegmentedStringWriter(this._streamFactory._getBufferRecycler());
        SerializationContextExt prov = this._serializerProvider();
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, (Writer)sw), value);
        return sw.getAndClear();
    }

    public byte[] writeValueAsBytes(Object value) throws JacksonException {
        SerializationContextExt prov = this._serializerProvider();
        ByteArrayBuilder bb = new ByteArrayBuilder(this._streamFactory._getBufferRecycler());
        this._configAndWriteValue(prov, this._streamFactory.createGenerator((ObjectWriteContext)prov, (OutputStream)bb, JsonEncoding.UTF8), value);
        byte[] result = bb.toByteArray();
        bb.release();
        return result;
    }

    protected final void _configAndWriteValue(SerializationContextExt prov, JsonGenerator g, Object value) throws JacksonException {
        if (prov.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._configAndWriteCloseable(prov, g, value);
            return;
        }
        try {
            prov.serializeValue(g, value);
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsJacksonE(g, e);
            return;
        }
        g.close();
    }

    private final void _configAndWriteCloseable(SerializationContextExt prov, JsonGenerator g, Object value) throws JacksonException {
        Closeable toClose = (Closeable)value;
        try {
            prov.serializeValue(g, value);
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsJacksonE(g, toClose, e);
            return;
        }
        g.close();
    }

    protected final void _writeCloseableValue(JsonGenerator g, Object value, SerializationConfig cfg) throws JacksonException {
        Closeable toClose = (Closeable)value;
        try {
            this._serializerProvider(cfg).serializeValue(g, value);
            if (cfg.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                g.flush();
            }
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsJacksonE(null, toClose, e);
            return;
        }
        try {
            toClose.close();
        }
        catch (IOException e) {
            throw WrappedIOException.construct((IOException)e);
        }
    }

    public ObjectWriter writer() {
        return this._newWriter(this.serializationConfig());
    }

    public ObjectWriter writer(SerializationFeature feature) {
        return this._newWriter(this.serializationConfig().with(feature));
    }

    public ObjectWriter writer(SerializationFeature first, SerializationFeature ... other) {
        return this._newWriter(this.serializationConfig().with(first, other));
    }

    public ObjectWriter writer(DateFormat df) {
        return this._newWriter(this.serializationConfig().with(df));
    }

    public ObjectWriter writerWithView(Class<?> serializationView) {
        return this._newWriter((SerializationConfig)this.serializationConfig().withView((Class)serializationView));
    }

    public ObjectWriter writerFor(Class<?> rootType) {
        return this._newWriter(this.serializationConfig(), rootType == null ? null : this._typeFactory.constructType(rootType), null);
    }

    public ObjectWriter writerFor(TypeReference<?> rootType) {
        return this._newWriter(this.serializationConfig(), rootType == null ? null : this._typeFactory.constructType(rootType), null);
    }

    public ObjectWriter writerFor(JavaType rootType) {
        return this._newWriter(this.serializationConfig(), rootType, null);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        SerializationConfig config = this.serializationConfig();
        return this._newWriter(config, null, config.getDefaultPrettyPrinter());
    }

    public ObjectWriter writer(FilterProvider filterProvider) {
        return this._newWriter(this.serializationConfig().withFilters(filterProvider));
    }

    public ObjectWriter writer(FormatSchema schema) {
        this._verifySchemaType(schema);
        return this._newWriter(this.serializationConfig(), schema);
    }

    public ObjectWriter writer(Base64Variant defaultBase64) {
        return this._newWriter((SerializationConfig)this.serializationConfig().with(defaultBase64));
    }

    public ObjectWriter writer(CharacterEscapes escapes) {
        return this._newWriter(this.serializationConfig()).with(escapes);
    }

    public ObjectWriter writer(ContextAttributes attrs) {
        return this._newWriter(this.serializationConfig().with(attrs));
    }

    public ObjectReader reader() {
        return this._newReader(this.deserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader reader(DeserializationFeature feature) {
        return this._newReader(this.deserializationConfig().with(feature));
    }

    public ObjectReader reader(DeserializationFeature first, DeserializationFeature ... other) {
        return this._newReader(this.deserializationConfig().with(first, other));
    }

    public ObjectReader readerForUpdating(Object valueToUpdate) {
        JavaType t = this._typeFactory.constructType(valueToUpdate.getClass());
        return this._newReader(this.deserializationConfig(), t, valueToUpdate, null, this._injectableValues);
    }

    public ObjectReader readerFor(JavaType type) {
        return this._newReader(this.deserializationConfig(), type, null, null, this._injectableValues);
    }

    public ObjectReader readerFor(Class<?> type) {
        return this._newReader(this.deserializationConfig(), this._typeFactory.constructType(type), null, null, this._injectableValues);
    }

    public ObjectReader readerFor(TypeReference<?> type) {
        return this._newReader(this.deserializationConfig(), this._typeFactory.constructType(type), null, null, this._injectableValues);
    }

    public ObjectReader readerForArrayOf(Class<?> type) {
        return this._newReader(this.deserializationConfig(), this._typeFactory.constructArrayType(type), null, null, this._injectableValues);
    }

    public ObjectReader readerForListOf(Class<?> type) {
        return this._newReader(this.deserializationConfig(), this._typeFactory.constructCollectionType(List.class, type), null, null, this._injectableValues);
    }

    public ObjectReader readerForMapOf(Class<?> type) {
        return this._newReader(this.deserializationConfig(), this._typeFactory.constructMapType(Map.class, String.class, type), null, null, this._injectableValues);
    }

    public ObjectReader reader(JsonNodeFactory f) {
        return this._newReader(this.deserializationConfig()).with(f);
    }

    public ObjectReader reader(FormatSchema schema) {
        this._verifySchemaType(schema);
        return this._newReader(this.deserializationConfig(), null, null, schema, this._injectableValues);
    }

    public ObjectReader reader(InjectableValues injectableValues) {
        return this._newReader(this.deserializationConfig(), null, null, null, injectableValues);
    }

    public ObjectReader readerWithView(Class<?> view) {
        return this._newReader((DeserializationConfig)this.deserializationConfig().withView((Class)view));
    }

    public ObjectReader reader(Base64Variant defaultBase64) {
        return this._newReader((DeserializationConfig)this.deserializationConfig().with(defaultBase64));
    }

    public ObjectReader reader(ContextAttributes attrs) {
        return this._newReader(this.deserializationConfig().with(attrs));
    }

    public <T> T convertValue(Object fromValue, Class<T> toValueType) throws IllegalArgumentException {
        this._assertNotNull("toValueType", toValueType);
        return (T)this._convert(fromValue, this._typeFactory.constructType(toValueType));
    }

    public <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) throws IllegalArgumentException {
        this._assertNotNull("toValueTypeRef", toValueTypeRef);
        return (T)this._convert(fromValue, this._typeFactory.constructType(toValueTypeRef));
    }

    public <T> T convertValue(Object fromValue, JavaType toValueType) throws IllegalArgumentException {
        this._assertNotNull("toValueType", toValueType);
        return (T)this._convert(fromValue, toValueType);
    }

    protected Object _convert(Object fromValue, JavaType toValueType) throws JacksonException {
        SerializationConfig config = this.serializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
        SerializationContextExt ctxt = this._serializerProvider(config);
        TokenBuffer buf = ctxt.bufferForValueConversion();
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            buf = buf.forceUseOfBigDecimal(true);
        }
        ctxt.serializeValue(buf, fromValue);
        DeserializationContextExt readCtxt = this._deserializationContext();
        try (JsonParser p = buf.asParser(readCtxt);){
            Object result;
            readCtxt.assignParser(p);
            JsonToken t = this._initForReading(p, toValueType);
            if (t == JsonToken.VALUE_NULL) {
                result = this._findRootDeserializer(readCtxt, toValueType).getNullValue(readCtxt);
            } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
                result = null;
            } else {
                ValueDeserializer<Object> deser = this._findRootDeserializer(readCtxt, toValueType);
                result = deser.deserialize(p, readCtxt);
            }
            Object object = result;
            return object;
        }
    }

    public <T> T updateValue(T valueToUpdate, Object overrides) throws JacksonException {
        if (valueToUpdate == null || overrides == null) {
            return valueToUpdate;
        }
        SerializationConfig config = this.serializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
        SerializationContextExt ctxt = this._serializerProvider(config);
        TokenBuffer buf = ctxt.bufferForValueConversion();
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            buf = buf.forceUseOfBigDecimal(true);
        }
        ctxt.serializeValue(buf, overrides);
        try (JsonParser p = buf.asParser(ObjectReadContext.empty());){
            Object t = this.readerForUpdating(valueToUpdate).readValue(p);
            return t;
        }
    }

    public void acceptJsonFormatVisitor(Class<?> type, JsonFormatVisitorWrapper visitor) {
        this._assertNotNull("type", type);
        this._assertNotNull("visitor", visitor);
        this.acceptJsonFormatVisitor(this._typeFactory.constructType(type), visitor);
    }

    public void acceptJsonFormatVisitor(TypeReference<?> typeRef, JsonFormatVisitorWrapper visitor) {
        this._assertNotNull("typeRef", typeRef);
        this._assertNotNull("visitor", visitor);
        this.acceptJsonFormatVisitor(this._typeFactory.constructType(typeRef), visitor);
    }

    public void acceptJsonFormatVisitor(JavaType type, JsonFormatVisitorWrapper visitor) {
        this._assertNotNull("type", type);
        this._assertNotNull("visitor", visitor);
        this._serializerProvider().acceptJsonFormatVisitor(type, visitor);
    }

    protected SerializationContextExt _serializerProvider(SerializationConfig config) {
        return this._serializationContexts.createContext(config, GeneratorSettings.empty());
    }

    public SerializationContextExt _serializerProvider() {
        return this._serializationContexts.createContext(this.serializationConfig(), GeneratorSettings.empty());
    }

    protected Object _readValue(DeserializationContextExt ctxt, JsonParser p, JavaType valueType) throws JacksonException {
        JsonToken t = this._initForReading(p, valueType);
        Object result = t == JsonToken.VALUE_NULL ? this._findRootDeserializer(ctxt, valueType).getNullValue(ctxt) : (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT ? null : ctxt.readRootValue(p, valueType, this._findRootDeserializer(ctxt, valueType), null));
        p.clearCurrentToken();
        if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p, ctxt, valueType);
        }
        return result;
    }

    protected Object _readMapAndClose(DeserializationContextExt ctxt, JsonParser p0, JavaType valueType) throws JacksonException {
        ctxt.assignParser(p0);
        try (JsonParser p = p0;){
            Object result;
            JsonToken t = this._initForReading(p, valueType);
            if (t == JsonToken.VALUE_NULL) {
                result = this._findRootDeserializer(ctxt, valueType).getNullValue(ctxt);
            } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
                result = null;
            } else {
                result = ctxt.readRootValue(p, valueType, this._findRootDeserializer(ctxt, valueType), null);
                ctxt.checkUnresolvedObjectId();
            }
            if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(p, ctxt, valueType);
            }
            Object object = result;
            return object;
        }
    }

    protected JsonNode _readTreeAndClose(DeserializationContextExt ctxt, JsonParser p0) throws JacksonException {
        try (JsonParser p = ctxt.assignAndReturnParser(p0);){
            JavaType valueType = JSON_NODE_TYPE;
            DeserializationConfig cfg = this.deserializationConfig();
            JsonToken t = p.currentToken();
            if (t == null && (t = p.nextToken()) == null) {
                JsonNode jsonNode = cfg.getNodeFactory().missingNode();
                return jsonNode;
            }
            JsonNode resultNode = t == JsonToken.VALUE_NULL ? cfg.getNodeFactory().nullNode() : (JsonNode)ctxt.readRootValue(p, valueType, this._findRootDeserializer(ctxt, valueType), null);
            if (cfg.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(p, ctxt, valueType);
            }
            NullNode nullNode = resultNode;
            return nullNode;
        }
    }

    protected DeserializationContextExt _deserializationContext(JsonParser p) {
        return this._deserializationContexts.createContext(this.deserializationConfig(), null, this._injectableValues).assignParser(p);
    }

    public DeserializationContextExt _deserializationContext() {
        return this._deserializationContexts.createContext(this.deserializationConfig(), null, this._injectableValues);
    }

    protected DeserializationContextExt _deserializationContext(DeserializationConfig config, JsonParser p) {
        return this._deserializationContexts.createContext(config, null, this._injectableValues).assignParser(p);
    }

    protected JsonToken _initForReading(JsonParser p, JavaType targetType) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == null && (t = p.nextToken()) == null) {
            throw MismatchedInputException.from(p, targetType, "No content to map due to end-of-input");
        }
        return t;
    }

    protected final void _verifyNoTrailingTokens(JsonParser p, DeserializationContext ctxt, JavaType bindType) throws JacksonException {
        JsonToken t = p.nextToken();
        if (t != null) {
            Class<?> bt = ClassUtil.rawClass(bindType);
            ctxt.reportTrailingTokens(bt, p, t);
        }
    }

    protected ObjectReader _newReader(DeserializationConfig config) {
        return new ObjectReader(this, config);
    }

    protected ObjectReader _newReader(DeserializationConfig config, JavaType valueType, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        return new ObjectReader(this, config, valueType, valueToUpdate, schema, injectableValues);
    }

    protected ObjectWriter _newWriter(SerializationConfig config) {
        return new ObjectWriter(this, config);
    }

    protected ObjectWriter _newWriter(SerializationConfig config, FormatSchema schema) {
        return new ObjectWriter(this, config, schema);
    }

    protected ObjectWriter _newWriter(SerializationConfig config, JavaType rootType, PrettyPrinter pp) {
        return new ObjectWriter(this, config, rootType, pp);
    }

    protected ValueDeserializer<Object> _findRootDeserializer(DeserializationContext ctxt, JavaType valueType) throws JacksonException {
        ValueDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser != null) {
            return deser;
        }
        deser = ctxt.findRootValueDeserializer(valueType);
        if (deser == null) {
            return (ValueDeserializer)ctxt.reportBadDefinition(valueType, "Cannot find a deserializer for type " + valueType);
        }
        this._rootDeserializers.put(valueType, deser);
        return deser;
    }

    protected void _verifySchemaType(FormatSchema schema) {
        if (schema != null && !this._streamFactory.canUseSchema(schema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + schema.getClass().getName() + " for format " + this._streamFactory.getFormatName());
        }
    }

    protected final void _assertNotNull(String paramName, Object src) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", paramName));
        }
    }

    private static class PrivateBuilder
    extends MapperBuilder<ObjectMapper, PrivateBuilder> {
        public PrivateBuilder(TokenStreamFactory tsf) {
            super(tsf);
        }

        @Override
        public ObjectMapper build() {
            return new ObjectMapper(this);
        }

        @Override
        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public PrivateBuilder(MapperBuilderState state) {
            super(state);
        }

        static class StateImpl
        extends MapperBuilderState {
            private static final long serialVersionUID = 3L;

            public StateImpl(PrivateBuilder b) {
                super(b);
            }

            @Override
            protected Object readResolve() {
                return new PrivateBuilder(this).build();
            }
        }
    }
}

