/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectWriteContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.exc.WrappedIOException;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.GeneratorSettings;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.cfg.SerializationContexts;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializationContextExt;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class ObjectWriter
implements Versioned {
    protected final SerializationConfig _config;
    protected final SerializationContexts _serializationContexts;
    protected final TokenStreamFactory _generatorFactory;
    protected final GeneratorSettings _generatorSettings;
    protected final Prefetch _prefetch;

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config, JavaType rootType, PrettyPrinter pp) {
        this._config = config;
        this._serializationContexts = mapper._serializationContexts;
        this._generatorFactory = mapper._streamFactory;
        GeneratorSettings generatorSettings = this._generatorSettings = pp == null ? GeneratorSettings.empty : new GeneratorSettings(pp, null, null, null);
        this._prefetch = rootType == null ? Prefetch.empty : (rootType.hasRawClass(Object.class) ? Prefetch.empty.forRootType(this, rootType) : Prefetch.empty.forRootType(this, rootType.withStaticTyping()));
    }

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config) {
        this._config = config;
        this._serializationContexts = mapper._serializationContexts;
        this._generatorFactory = mapper._streamFactory;
        this._generatorSettings = GeneratorSettings.empty;
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config, FormatSchema s) {
        this._config = config;
        this._serializationContexts = mapper._serializationContexts;
        this._generatorFactory = mapper._streamFactory;
        this._generatorSettings = s == null ? GeneratorSettings.empty : new GeneratorSettings(null, s, null, null);
        this._prefetch = Prefetch.empty;
    }

    protected ObjectWriter(ObjectWriter base, SerializationConfig config, GeneratorSettings genSettings, Prefetch prefetch) {
        this._config = config;
        this._serializationContexts = base._serializationContexts;
        this._generatorFactory = base._generatorFactory;
        this._generatorSettings = genSettings;
        this._prefetch = prefetch;
    }

    protected ObjectWriter(ObjectWriter base, SerializationConfig config) {
        this._config = config;
        this._serializationContexts = base._serializationContexts;
        this._generatorFactory = base._generatorFactory;
        this._generatorSettings = base._generatorSettings;
        this._prefetch = base._prefetch;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectWriter _new(ObjectWriter base, SerializationConfig config) {
        if (config == this._config) {
            return this;
        }
        return new ObjectWriter(base, config);
    }

    protected ObjectWriter _new(GeneratorSettings genSettings, Prefetch prefetch) {
        if (this._generatorSettings == genSettings && this._prefetch == prefetch) {
            return this;
        }
        return new ObjectWriter(this, this._config, genSettings, prefetch);
    }

    protected final SequenceWriter _newSequenceWriter(SerializationContextExt ctxt, boolean wrapInArray, JsonGenerator gen, boolean managedInput) throws JacksonException {
        return new SequenceWriter(ctxt, gen, managedInput, this._prefetch).init(wrapInArray);
    }

    public ObjectWriter with(SerializationFeature feature) {
        return this._new(this, this._config.with(feature));
    }

    public ObjectWriter with(SerializationFeature first, SerializationFeature ... other) {
        return this._new(this, this._config.with(first, other));
    }

    public ObjectWriter withFeatures(SerializationFeature ... features) {
        return this._new(this, this._config.withFeatures(features));
    }

    public ObjectWriter without(SerializationFeature feature) {
        return this._new(this, this._config.without(feature));
    }

    public ObjectWriter without(SerializationFeature first, SerializationFeature ... other) {
        return this._new(this, this._config.without(first, other));
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... features) {
        return this._new(this, this._config.withoutFeatures(features));
    }

    public ObjectWriter with(StreamWriteFeature feature) {
        return this._new(this, this._config.with(feature));
    }

    public ObjectWriter withFeatures(StreamWriteFeature ... features) {
        return this._new(this, this._config.withFeatures(features));
    }

    public ObjectWriter without(StreamWriteFeature feature) {
        return this._new(this, this._config.without(feature));
    }

    public ObjectWriter withoutFeatures(StreamWriteFeature ... features) {
        return this._new(this, this._config.withoutFeatures(features));
    }

    public ObjectWriter with(FormatFeature feature) {
        return this._new(this, this._config.with(feature));
    }

    public ObjectWriter withFeatures(FormatFeature ... features) {
        return this._new(this, this._config.withFeatures(features));
    }

    public ObjectWriter without(FormatFeature feature) {
        return this._new(this, this._config.without(feature));
    }

    public ObjectWriter withoutFeatures(FormatFeature ... features) {
        return this._new(this, this._config.withoutFeatures(features));
    }

    public ObjectWriter forType(JavaType rootType) {
        return this._new(this._generatorSettings, this._prefetch.forRootType(this, rootType));
    }

    public ObjectWriter forType(Class<?> rootType) {
        return this.forType(this._config.constructType(rootType));
    }

    public ObjectWriter forType(TypeReference<?> rootType) {
        return this.forType(this._config.getTypeFactory().constructType(rootType.getType()));
    }

    public ObjectWriter with(DateFormat df) {
        return this._new(this, this._config.with(df));
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(this._config.getDefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        return this._new(this, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter pp) {
        return this._new(this._generatorSettings.with(pp), this._prefetch);
    }

    public ObjectWriter withRootName(String rootName) {
        return this._new(this, (SerializationConfig)this._config.withRootName(rootName));
    }

    public ObjectWriter withRootName(PropertyName rootName) {
        return this._new(this, this._config.withRootName(rootName));
    }

    public ObjectWriter withoutRootName() {
        return this._new(this, this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectWriter with(FormatSchema schema) {
        this._verifySchemaType(schema);
        return this._new(this._generatorSettings.with(schema), this._prefetch);
    }

    public ObjectWriter withView(Class<?> view) {
        return this._new(this, (SerializationConfig)this._config.withView((Class)view));
    }

    public ObjectWriter with(Locale l) {
        return this._new(this, (SerializationConfig)this._config.with(l));
    }

    public ObjectWriter with(TimeZone tz) {
        return this._new(this, (SerializationConfig)this._config.with(tz));
    }

    public ObjectWriter with(Base64Variant b64variant) {
        return this._new(this, (SerializationConfig)this._config.with(b64variant));
    }

    public ObjectWriter with(CharacterEscapes escapes) {
        return this._new(this._generatorSettings.with(escapes), this._prefetch);
    }

    public ObjectWriter with(ContextAttributes attrs) {
        return this._new(this, this._config.with(attrs));
    }

    public ObjectWriter withAttributes(Map<?, ?> attrs) {
        return this._new(this, (SerializationConfig)this._config.withAttributes(attrs));
    }

    public ObjectWriter withAttribute(Object key, Object value) {
        return this._new(this, (SerializationConfig)this._config.withAttribute(key, value));
    }

    public ObjectWriter withoutAttribute(Object key) {
        return this._new(this, (SerializationConfig)this._config.withoutAttribute(key));
    }

    public ObjectWriter withRootValueSeparator(String sep) {
        return this._new(this._generatorSettings.withRootValueSeparator(sep), this._prefetch);
    }

    public ObjectWriter withRootValueSeparator(SerializableString sep) {
        return this._new(this._generatorSettings.withRootValueSeparator(sep), this._prefetch);
    }

    public JsonGenerator createGenerator(OutputStream target) {
        this._assertNotNull("target", target);
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), target);
    }

    public JsonGenerator createGenerator(OutputStream target, JsonEncoding enc) {
        this._assertNotNull("target", target);
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), target, enc);
    }

    public JsonGenerator createGenerator(Writer target) {
        this._assertNotNull("target", target);
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), target);
    }

    public JsonGenerator createGenerator(File target, JsonEncoding enc) {
        this._assertNotNull("target", target);
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), target, enc);
    }

    public JsonGenerator createGenerator(Path target, JsonEncoding enc) {
        this._assertNotNull("target", target);
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), target, enc);
    }

    public JsonGenerator createGenerator(DataOutput target) {
        this._assertNotNull("target", target);
        return this._generatorFactory.createGenerator((ObjectWriteContext)this._serializerProvider(), target);
    }

    public ObjectNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    public ArrayNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    public SequenceWriter writeValues(File target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, false, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(Path target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, false, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(JsonGenerator g) throws JacksonException {
        this._assertNotNull("target", g);
        return this._newSequenceWriter(this._serializerProvider(), false, g, false);
    }

    public SequenceWriter writeValues(Writer target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, false, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target), true);
    }

    public SequenceWriter writeValues(OutputStream target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, false, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(DataOutput target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, false, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target), true);
    }

    public SequenceWriter writeValuesAsArray(File target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, true, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(Path target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, true, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(JsonGenerator g) throws JacksonException {
        this._assertNotNull("g", g);
        return this._newSequenceWriter(this._serializerProvider(), true, g, false);
    }

    public SequenceWriter writeValuesAsArray(Writer target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, true, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target), true);
    }

    public SequenceWriter writeValuesAsArray(OutputStream target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, true, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(DataOutput target) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        return this._newSequenceWriter(ctxt, true, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target), true);
    }

    public boolean isEnabled(SerializationFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(MapperFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(StreamWriteFeature f) {
        return this._generatorFactory.isEnabled(f);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    public TokenStreamFactory generatorFactory() {
        return this._generatorFactory;
    }

    public TypeFactory typeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._prefetch.hasSerializer();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    @Deprecated
    public TypeFactory getTypeFactory() {
        return this.typeFactory();
    }

    public void writeValue(JsonGenerator g, Object value) throws JacksonException {
        this._assertNotNull("g", g);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            Closeable toClose = (Closeable)value;
            try {
                this._prefetch.serialize(g, value, this._serializerProvider());
                if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                    g.flush();
                }
            }
            catch (Exception e) {
                ClassUtil.closeOnFailAndThrowAsJacksonE(null, toClose, e);
                return;
            }
            try {
                toClose.close();
            }
            catch (IOException e) {
                throw WrappedIOException.construct((IOException)e, (Object)g);
            }
        }
        this._prefetch.serialize(g, value, this._serializerProvider());
        if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            g.flush();
        }
    }

    public void writeValue(File target, Object value) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        this._configAndWriteValue(ctxt, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), value);
    }

    public void writeValue(Path target, Object value) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        this._configAndWriteValue(ctxt, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), value);
    }

    public void writeValue(OutputStream target, Object value) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        this._configAndWriteValue(ctxt, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target, JsonEncoding.UTF8), value);
    }

    public void writeValue(Writer target, Object value) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        this._configAndWriteValue(ctxt, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target), value);
    }

    public void writeValue(DataOutput target, Object value) throws JacksonException {
        this._assertNotNull("target", target);
        SerializationContextExt ctxt = this._serializerProvider();
        this._configAndWriteValue(ctxt, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, target), value);
    }

    public String writeValueAsString(Object value) throws JacksonException {
        SegmentedStringWriter sw = new SegmentedStringWriter(this._generatorFactory._getBufferRecycler());
        SerializationContextExt ctxt = this._serializerProvider();
        this._configAndWriteValue(ctxt, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, (Writer)sw), value);
        return sw.getAndClear();
    }

    public byte[] writeValueAsBytes(Object value) throws JacksonException {
        ByteArrayBuilder bb = new ByteArrayBuilder(this._generatorFactory._getBufferRecycler());
        SerializationContextExt ctxt = this._serializerProvider();
        this._configAndWriteValue(ctxt, this._generatorFactory.createGenerator((ObjectWriteContext)ctxt, (OutputStream)bb, JsonEncoding.UTF8), value);
        byte[] result = bb.toByteArray();
        bb.release();
        return result;
    }

    protected final void _configAndWriteValue(SerializationContextExt ctxt, JsonGenerator gen, Object value) throws JacksonException {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseable(gen, value);
            return;
        }
        try {
            this._prefetch.serialize(gen, value, ctxt);
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsJacksonE(gen, e);
            return;
        }
        gen.close();
    }

    private final void _writeCloseable(JsonGenerator gen, Object value) throws JacksonException {
        Closeable toClose = (Closeable)value;
        try {
            this._prefetch.serialize(gen, value, this._serializerProvider());
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        catch (Exception e) {
            ClassUtil.closeOnFailAndThrowAsJacksonE(gen, toClose, e);
            return;
        }
        gen.close();
    }

    public <T extends JsonNode> T valueToTree(Object fromValue) throws JacksonException {
        return this._serializerProvider().valueToTree(fromValue);
    }

    public void acceptJsonFormatVisitor(JavaType type, JsonFormatVisitorWrapper visitor) {
        this._assertNotNull("type", type);
        this._assertNotNull("visitor", visitor);
        this._serializerProvider().acceptJsonFormatVisitor(type, visitor);
    }

    public void acceptJsonFormatVisitor(Class<?> type, JsonFormatVisitorWrapper visitor) {
        this._assertNotNull("type", type);
        this._assertNotNull("visitor", visitor);
        this.acceptJsonFormatVisitor(this._config.constructType(type), visitor);
    }

    protected final SerializationContextExt _serializerProvider() {
        return this._serializationContexts.createContext(this._config, this._generatorSettings);
    }

    protected void _verifySchemaType(FormatSchema schema) {
        if (schema != null && !this._generatorFactory.canUseSchema(schema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + schema.getClass().getName() + " for format " + this._generatorFactory.getFormatName());
        }
    }

    protected final void _assertNotNull(String paramName, Object src) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", paramName));
        }
    }

    public static final class Prefetch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final Prefetch empty = new Prefetch(null, null, null);
        private final JavaType rootType;
        private final ValueSerializer<Object> valueSerializer;
        private final TypeSerializer typeSerializer;

        private Prefetch(JavaType rootT, ValueSerializer<Object> ser, TypeSerializer typeSer) {
            this.rootType = rootT;
            this.valueSerializer = ser;
            this.typeSerializer = typeSer;
        }

        public Prefetch forRootType(ObjectWriter parent, JavaType newType) {
            if (newType == null) {
                if (this.rootType == null || this.valueSerializer == null) {
                    return this;
                }
                return new Prefetch(null, null, null);
            }
            if (newType.equals(this.rootType)) {
                return this;
            }
            if (newType.isJavaLangObject()) {
                SerializationContextExt ctxt = parent._serializerProvider();
                TypeSerializer typeSer = ctxt.findTypeSerializer(newType);
                return new Prefetch(null, null, typeSer);
            }
            if (parent.isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
                SerializationContextExt ctxt = parent._serializerProvider();
                try {
                    ValueSerializer<Object> ser = ctxt.findTypedValueSerializer(newType, true);
                    if (ser instanceof TypeWrappedSerializer) {
                        return new Prefetch(newType, null, ((TypeWrappedSerializer)ser).typeSerializer());
                    }
                    return new Prefetch(newType, ser, null);
                }
                catch (JacksonException jacksonException) {
                    // empty catch block
                }
            }
            return new Prefetch(newType, null, this.typeSerializer);
        }

        public final ValueSerializer<Object> getValueSerializer() {
            return this.valueSerializer;
        }

        public final TypeSerializer getTypeSerializer() {
            return this.typeSerializer;
        }

        public boolean hasSerializer() {
            return this.valueSerializer != null || this.typeSerializer != null;
        }

        public void serialize(JsonGenerator gen, Object value, SerializationContextExt ctxt) throws JacksonException {
            if (this.typeSerializer != null) {
                ctxt.serializePolymorphic(gen, value, this.rootType, this.valueSerializer, this.typeSerializer);
            } else if (this.valueSerializer != null) {
                ctxt.serializeValue(gen, value, this.rootType, this.valueSerializer);
            } else if (this.rootType != null) {
                ctxt.serializeValue(gen, value, this.rootType);
            } else {
                ctxt.serializeValue(gen, value);
            }
        }
    }
}

