/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.Collection;

public abstract class ValueDeserializer<T>
implements NullValueProvider {
    public void resolve(DeserializationContext ctxt) {
    }

    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        return this;
    }

    public abstract T deserialize(JsonParser var1, DeserializationContext var2) throws JacksonException;

    public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws JacksonException {
        ctxt.handleBadMerge(this);
        return this.deserialize(p, ctxt);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        return typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer, T intoValue) throws JacksonException {
        ctxt.handleBadMerge(this);
        return this.deserializeWithType(p, ctxt, typeDeserializer);
    }

    public ValueDeserializer<T> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer unwrapper) {
        return this;
    }

    public ValueDeserializer<?> replaceDelegatee(ValueDeserializer<?> delegatee) {
        throw new UnsupportedOperationException();
    }

    public Class<?> handledType() {
        return null;
    }

    public LogicalType logicalType() {
        return null;
    }

    public boolean isCachable() {
        return false;
    }

    public ValueDeserializer<?> getDelegatee() {
        return null;
    }

    public Collection<Object> getKnownPropertyNames() {
        return null;
    }

    @Override
    public Object getNullValue(DeserializationContext ctxt) {
        return null;
    }

    @Override
    public AccessPattern getNullAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    public Object getEmptyValue(DeserializationContext ctxt) {
        return this.getNullValue(ctxt);
    }

    public ObjectIdReader getObjectIdReader(DeserializationContext ctxt) {
        return null;
    }

    public SettableBeanProperty findBackReference(String refName) {
        throw new IllegalArgumentException("Cannot handle managed/back reference '" + refName + "': type: value deserializer of type " + this.getClass().getName() + " does not support them");
    }

    public Boolean supportsUpdate(DeserializationConfig config) {
        return null;
    }

    public static abstract class None
    extends ValueDeserializer<Object> {
        private None() {
        }
    }
}

