/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.MixInHandler;
import com.fasterxml.jackson.databind.introspect.MixInResolver;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeResolverProvider;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public abstract class MapperConfigBase<CFG extends ConfigFeature, T extends MapperConfigBase<CFG, T>>
extends MapperConfig<T>
implements Serializable {
    protected static final ConfigOverride EMPTY_OVERRIDE = ConfigOverride.empty();
    protected final TypeFactory _typeFactory;
    protected final ClassIntrospector _classIntrospector;
    protected final TypeResolverProvider _typeResolverProvider;
    protected final SubtypeResolver _subtypeResolver;
    protected final MixInHandler _mixIns;
    protected final PropertyName _rootName;
    protected final Class<?> _view;
    protected final ContextAttributes _attributes;
    protected final RootNameLookup _rootNames;
    protected final ConfigOverrides _configOverrides;

    protected MapperConfigBase(MapperBuilder<?, ?> b, long mapperFeatures, TypeFactory tf, ClassIntrospector classIntr, MixInHandler mixins, SubtypeResolver str, ConfigOverrides configOverrides, ContextAttributes defaultAttrs, RootNameLookup rootNames) {
        super(b.baseSettings(), mapperFeatures);
        this._typeFactory = tf;
        this._classIntrospector = classIntr;
        this._typeResolverProvider = b.typeResolverProvider();
        this._subtypeResolver = str;
        this._mixIns = mixins;
        this._rootNames = rootNames;
        this._rootName = null;
        this._view = null;
        this._attributes = defaultAttrs;
        this._configOverrides = configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, BaseSettings base) {
        super(src, base);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, PropertyName rootName) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = rootName;
        this._view = src._view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, Class<?> view) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = view;
        this._attributes = src._attributes;
        this._configOverrides = src._configOverrides;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> src, ContextAttributes attr) {
        super(src);
        this._typeFactory = src._typeFactory;
        this._classIntrospector = src._classIntrospector;
        this._typeResolverProvider = src._typeResolverProvider;
        this._subtypeResolver = src._subtypeResolver;
        this._mixIns = src._mixIns;
        this._rootNames = src._rootNames;
        this._rootName = src._rootName;
        this._view = src._view;
        this._attributes = attr;
        this._configOverrides = src._configOverrides;
    }

    protected abstract T _withBase(BaseSettings var1);

    public abstract T with(ContextAttributes var1);

    public T withAttributes(Map<?, ?> attributes) {
        return this.with(this.getAttributes().withSharedAttributes(attributes));
    }

    public T withAttribute(Object key, Object value) {
        return this.with(this.getAttributes().withSharedAttribute(key, value));
    }

    public T withoutAttribute(Object key) {
        return this.with(this.getAttributes().withoutSharedAttribute(key));
    }

    public final T with(TypeResolverBuilder<?> trb) {
        return this._withBase(this._base.with(trb));
    }

    public final T with(JsonNodeFactory f) {
        return this._withBase(this._base.with(f));
    }

    public final T with(Base64Variant base64) {
        return this._withBase(this._base.with(base64));
    }

    public T with(DateFormat df) {
        return this._withBase(this._base.with(df));
    }

    public final T with(Locale l) {
        return this._withBase(this._base.with(l));
    }

    public final T with(TimeZone tz) {
        return this._withBase(this._base.with(tz));
    }

    public abstract T withRootName(PropertyName var1);

    public T withRootName(String rootName) {
        if (rootName == null) {
            return this.withRootName((PropertyName)null);
        }
        return this.withRootName(PropertyName.construct(rootName));
    }

    public abstract T withView(Class<?> var1);

    @Override
    public final TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    @Override
    public ClassIntrospector classIntrospectorInstance() {
        return this._classIntrospector.forOperation(this);
    }

    @Override
    public TypeResolverProvider getTypeResolverProvider() {
        return this._typeResolverProvider;
    }

    @Override
    public final SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    @Override
    public final JavaType constructType(Class<?> cls) {
        return this._typeFactory.constructType(cls);
    }

    @Override
    public final JavaType constructType(TypeReference<?> valueTypeRef) {
        return this._typeFactory.constructType(valueTypeRef.getType());
    }

    public final PropertyName getFullRootName() {
        return this._rootName;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final ContextAttributes getAttributes() {
        return this._attributes;
    }

    @Override
    public final ConfigOverride getConfigOverride(Class<?> type) {
        ConfigOverride override = this._configOverrides.findOverride(type);
        return override == null ? EMPTY_OVERRIDE : override;
    }

    @Override
    public final ConfigOverride findConfigOverride(Class<?> type) {
        return this._configOverrides.findOverride(type);
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion() {
        return this._configOverrides.getDefaultInclusion();
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> baseType) {
        JsonInclude.Value v = this.getConfigOverride(baseType).getInclude();
        JsonInclude.Value def = this.getDefaultPropertyInclusion();
        if (def == null) {
            return v;
        }
        return def.withOverrides(v);
    }

    @Override
    public final JsonInclude.Value getDefaultInclusion(Class<?> baseType, Class<?> propertyType) {
        JsonInclude.Value v = this.getConfigOverride(propertyType).getIncludeAsProperty();
        JsonInclude.Value def = this.getDefaultPropertyInclusion(baseType);
        if (def == null) {
            return v;
        }
        return def.withOverrides(v);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> type) {
        return this._configOverrides.findFormatDefaults(type);
    }

    @Override
    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> type) {
        JsonIgnoreProperties.Value v;
        ConfigOverride overrides = this._configOverrides.findOverride(type);
        if (overrides != null && (v = overrides.getIgnorals()) != null) {
            return v;
        }
        return null;
    }

    @Override
    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> baseType, AnnotatedClass actualClass) {
        AnnotationIntrospector intr = this.getAnnotationIntrospector();
        JsonIgnoreProperties.Value base = intr == null ? null : intr.findPropertyIgnoralByName(this, actualClass);
        JsonIgnoreProperties.Value overrides = this.getDefaultPropertyIgnorals(baseType);
        return JsonIgnoreProperties.Value.merge((JsonIgnoreProperties.Value)base, (JsonIgnoreProperties.Value)overrides);
    }

    @Override
    public final JsonIncludeProperties.Value getDefaultPropertyInclusions(Class<?> baseType, AnnotatedClass actualClass) {
        AnnotationIntrospector intr = this.getAnnotationIntrospector();
        return intr == null ? null : intr.findPropertyInclusionByName(this, actualClass);
    }

    @Override
    public final VisibilityChecker getDefaultVisibilityChecker() {
        return this._configOverrides.getDefaultVisibility();
    }

    @Override
    public final VisibilityChecker getDefaultVisibilityChecker(Class<?> baseType, AnnotatedClass actualClass) {
        ConfigOverride overrides;
        VisibilityChecker vc = ClassUtil.isJDKClass(baseType) ? VisibilityChecker.allPublicInstance() : this.getDefaultVisibilityChecker();
        AnnotationIntrospector intr = this.getAnnotationIntrospector();
        if (intr != null) {
            vc = intr.findAutoDetectVisibility(this, actualClass, vc);
        }
        if ((overrides = this._configOverrides.findOverride(baseType)) != null) {
            vc = vc.withOverrides(overrides.getVisibility());
        }
        return vc;
    }

    @Override
    public final JsonSetter.Value getDefaultNullHandling() {
        return this._configOverrides.getDefaultNullHandling();
    }

    @Override
    public Boolean getDefaultMergeable() {
        return this._configOverrides.getDefaultMergeable();
    }

    @Override
    public Boolean getDefaultMergeable(Class<?> baseType) {
        Boolean b;
        ConfigOverride cfg = this._configOverrides.findOverride(baseType);
        if (cfg != null && (b = cfg.getMergeable()) != null) {
            return b;
        }
        return this._configOverrides.getDefaultMergeable();
    }

    @Override
    public PropertyName findRootName(DatabindContext ctxt, JavaType rootType) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(ctxt, rootType);
    }

    @Override
    public PropertyName findRootName(DatabindContext ctxt, Class<?> rawRootType) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(ctxt, rawRootType);
    }

    @Override
    public final Class<?> findMixInClassFor(Class<?> cls) {
        return this._mixIns.findMixInClassFor(cls);
    }

    @Override
    public boolean hasMixIns() {
        return this._mixIns.hasMixIns();
    }

    @Override
    public MixInResolver snapshot() {
        throw new UnsupportedOperationException();
    }

    public final int mixInCount() {
        return this._mixIns.localSize();
    }
}

