/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.bean;

import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.sym.PropertyNameMatcher;
import com.fasterxml.jackson.core.util.InternCache;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

public class BeanPropertyMap
implements Iterable<SettableBeanProperty> {
    private SettableBeanProperty[] _propsInOrder;
    private final PropertyName[][] _aliasDefs;
    private final Locale _locale;
    private final boolean _caseInsensitive;
    private transient PropertyNameMatcher _nameMatcher;
    private transient SettableBeanProperty[] _propsWithAliases;

    protected BeanPropertyMap(Collection<SettableBeanProperty> props, PropertyName[][] aliasDefs, Locale locale, boolean caseInsensitive, boolean assignIndexes) {
        this._locale = locale;
        this._caseInsensitive = caseInsensitive;
        this._aliasDefs = aliasDefs;
        this._propsInOrder = props.toArray(new SettableBeanProperty[0]);
        if (assignIndexes) {
            int end = props.size();
            for (int i = 0; i < end; ++i) {
                this._propsInOrder[i].assignIndex(i);
            }
        }
    }

    protected BeanPropertyMap(BeanPropertyMap base, boolean caseInsensitive) {
        this._locale = base._locale;
        this._caseInsensitive = caseInsensitive;
        this._aliasDefs = base._aliasDefs;
        this._propsInOrder = Arrays.copyOf(base._propsInOrder, base._propsInOrder.length);
    }

    public static BeanPropertyMap construct(MapperConfig<?> config, Collection<SettableBeanProperty> props, PropertyName[][] aliases, boolean caseInsensitive) {
        return new BeanPropertyMap(props, aliases, config.getLocale(), caseInsensitive, true);
    }

    public BeanPropertyMap withCaseInsensitivity(boolean state) {
        if (this._caseInsensitive == state) {
            return this;
        }
        return new BeanPropertyMap(this, state);
    }

    public BeanPropertyMap withProperty(SettableBeanProperty newProp) {
        String key = newProp.getName();
        int end = this._propsInOrder.length;
        for (int i = 0; i < end; ++i) {
            if (!this._propsInOrder[i].getName().equals(key)) continue;
            this._propsInOrder[i] = newProp;
            return this;
        }
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>(Arrays.asList(this._propsInOrder));
        newProps.add(newProp);
        return new BeanPropertyMap(newProps, this._aliasDefs, this._locale, this._caseInsensitive, false);
    }

    public BeanPropertyMap renameAll(DeserializationContext ctxt, NameTransformer transformer) {
        if (transformer == null || transformer == NameTransformer.NOP) {
            return this;
        }
        int len = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>(this._propsInOrder.length);
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty orig = this._propsInOrder[i];
            SettableBeanProperty prop = this._rename(ctxt, orig, transformer);
            newProps.add(prop);
        }
        return new BeanPropertyMap(newProps, this._aliasDefs, this._locale, this._caseInsensitive, false).initMatcher(ctxt.getParserFactory());
    }

    private SettableBeanProperty _rename(DeserializationContext ctxt, SettableBeanProperty prop, NameTransformer xf) {
        if (prop != null) {
            ValueDeserializer<Object> newDeser;
            String newName = xf.transform(prop.getName());
            ValueDeserializer<Object> deser = (prop = prop.withSimpleName(newName = InternCache.instance.intern(newName))).getValueDeserializer();
            if (deser != null && (newDeser = deser.unwrappingDeserializer(ctxt, xf)) != deser) {
                prop = prop.withValueDeserializer(newDeser);
            }
        }
        return prop;
    }

    public BeanPropertyMap withoutProperties(Collection<String> toExclude) {
        return this.withoutProperties(toExclude, null);
    }

    public BeanPropertyMap withoutProperties(Collection<String> toExclude, Collection<String> toInclude) {
        if (toExclude == null || toExclude.isEmpty()) {
            if (toInclude == null) {
                return this;
            }
            toExclude = Collections.emptySet();
        }
        int len = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> newProps = new ArrayList<SettableBeanProperty>(len);
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._propsInOrder[i];
            if (toExclude.contains(prop.getName()) || IgnorePropertiesUtil.shouldIgnore(prop.getName(), toExclude, toInclude)) continue;
            newProps.add(prop);
        }
        return new BeanPropertyMap(newProps, this._aliasDefs, this._locale, this._caseInsensitive, false);
    }

    public void replace(SettableBeanProperty oldProp, SettableBeanProperty newProp) {
        int end = this._propsInOrder.length;
        for (int i = 0; i < end; ++i) {
            if (this._propsInOrder[i] != oldProp) continue;
            this._propsInOrder[i] = newProp;
            return;
        }
        throw new NoSuchElementException("No entry '" + oldProp.getName() + "' found, can't replace");
    }

    public void remove(SettableBeanProperty propToRm) {
        String key = propToRm.getName();
        ArrayList<SettableBeanProperty> props = new ArrayList<SettableBeanProperty>(this._propsInOrder.length);
        boolean found = false;
        for (SettableBeanProperty prop : this._propsInOrder) {
            String match;
            if (!found && (found = (match = prop.getName()).equals(key))) continue;
            props.add(prop);
        }
        if (!found) {
            throw new NoSuchElementException("No entry '" + propToRm.getName() + "' found, can't remove");
        }
        this._propsInOrder = props.toArray(new SettableBeanProperty[0]);
    }

    public BeanPropertyMap initMatcher(TokenStreamFactory tsf) {
        List<SettableBeanProperty> names;
        if (this._aliasDefs == null) {
            this._propsWithAliases = this._propsInOrder;
            names = Arrays.asList(this._propsInOrder);
        } else {
            ArrayList<SettableBeanProperty> allProps = new ArrayList<SettableBeanProperty>(Arrays.asList(this._propsInOrder));
            names = new ArrayList<SettableBeanProperty>(allProps);
            int end = this._aliasDefs.length;
            for (int i = 0; i < end; ++i) {
                PropertyName[] aliases = this._aliasDefs[i];
                if (aliases == null) continue;
                SettableBeanProperty primary = this._propsInOrder[i];
                for (PropertyName alias : aliases) {
                    names.add((SettableBeanProperty)((Object)alias));
                    allProps.add(primary);
                }
            }
            this._propsWithAliases = allProps.toArray(new SettableBeanProperty[0]);
        }
        this._nameMatcher = this._caseInsensitive ? tsf.constructCINameMatcher(names, true, this._locale) : tsf.constructNameMatcher(names, true);
        return this;
    }

    public PropertyNameMatcher getNameMatcher() {
        return this._nameMatcher;
    }

    public SettableBeanProperty[] getNameMatcherProperties() {
        return this._propsWithAliases;
    }

    public int size() {
        return this._propsInOrder.length;
    }

    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }

    public boolean hasAliases() {
        return this._aliasDefs != null;
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return Arrays.asList(this._propsInOrder).iterator();
    }

    public SettableBeanProperty[] getPrimaryProperties() {
        return this._propsInOrder;
    }

    public SettableBeanProperty findDefinition(int index) {
        for (SettableBeanProperty prop : this._propsInOrder) {
            if (prop == null || index != prop.getPropertyIndex()) continue;
            return prop;
        }
        return null;
    }

    public SettableBeanProperty findDefinition(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Cannot pass null property name");
        }
        for (SettableBeanProperty prop : this._propsInOrder) {
            if (!key.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Properties=[");
        int count = 0;
        for (SettableBeanProperty prop : this) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(String.format("%s(%s)", prop.getName(), prop.getType()));
        }
        sb.append(']');
        if (this._aliasDefs != null) {
            sb.append(String.format("(aliases: %s)", this._aliasDefs.length));
        }
        return sb.toString();
    }
}

