/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;

public class JsonLocationInstantiator
extends ValueInstantiator.Base {
    public JsonLocationInstantiator() {
        super(JsonLocation.class);
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return true;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        JavaType intType = config.constructType(Integer.TYPE);
        JavaType longType = config.constructType(Long.TYPE);
        return new SettableBeanProperty[]{JsonLocationInstantiator.creatorProp("byteOffset", longType, 0, true), JsonLocationInstantiator.creatorProp("charOffset", longType, 1, true), JsonLocationInstantiator.creatorProp("lineNr", intType, 2, true), JsonLocationInstantiator.creatorProp("columnNr", intType, 3, true), JsonLocationInstantiator.creatorProp("sourceRef", config.constructType(Object.class), 4, false)};
    }

    private static CreatorProperty creatorProp(String name, JavaType type, int index, boolean req) {
        return CreatorProperty.construct(PropertyName.construct(name), type, null, null, null, null, index, null, req ? PropertyMetadata.STD_REQUIRED : PropertyMetadata.STD_OPTIONAL);
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) {
        ContentReference srcRef = ContentReference.unknown();
        return new JsonLocation(srcRef, JsonLocationInstantiator._long(args[0]), JsonLocationInstantiator._long(args[1]), JsonLocationInstantiator._int(args[2]), JsonLocationInstantiator._int(args[3]));
    }

    private static final long _long(Object o) {
        return o == null ? 0L : ((Number)o).longValue();
    }

    private static final int _int(Object o) {
        return o == null ? 0 : ((Number)o).intValue();
    }
}

