/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jdk;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicIntegerDeserializer
extends StdScalarDeserializer<AtomicInteger> {
    public AtomicIntegerDeserializer() {
        super(AtomicInteger.class);
    }

    @Override
    public AtomicInteger deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.isExpectedNumberIntToken()) {
            return new AtomicInteger(p.getIntValue());
        }
        Integer I = this._parseInteger(p, ctxt, AtomicInteger.class);
        return I == null ? null : new AtomicInteger(I);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) {
        return new AtomicInteger();
    }
}

