/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.jdk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ValueDeserializer;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.jdk.JDKKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

public class JDKKeyDeserializers
implements KeyDeserializers {
    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new JDKKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod factory) {
        return new JDKKeyDeserializer.EnumKD(enumResolver, factory);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config, JavaType type, ValueDeserializer<?> deser) {
        return new JDKKeyDeserializer.DelegatingKD(type.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationContext ctxt, JavaType type) {
        BeanDescription beanDesc = ctxt.introspectBeanDescriptionForCreation(type);
        AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> ctorInfo = JDKKeyDeserializers._findStringConstructor(beanDesc);
        if (ctorInfo != null && ctorInfo.metadata != null) {
            return JDKKeyDeserializers._constructCreatorKeyDeserializer(ctxt, (AnnotatedMember)ctorInfo.annotated);
        }
        List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> factoryCandidates = beanDesc.getFactoryMethodsWithMode();
        factoryCandidates.removeIf(m -> ((AnnotatedMethod)m.annotated).getParameterCount() != 1 || ((AnnotatedMethod)m.annotated).getRawParameterType(0) != String.class || m.metadata == JsonCreator.Mode.PROPERTIES);
        AnnotatedMethod explicitFactory = JDKKeyDeserializers._findExplicitStringFactoryMethod(ctxt, factoryCandidates);
        if (explicitFactory != null) {
            return JDKKeyDeserializers._constructCreatorKeyDeserializer(ctxt, explicitFactory);
        }
        if (ctorInfo != null) {
            return JDKKeyDeserializers._constructCreatorKeyDeserializer(ctxt, (AnnotatedMember)ctorInfo.annotated);
        }
        if (!factoryCandidates.isEmpty()) {
            return JDKKeyDeserializers._constructCreatorKeyDeserializer(ctxt, (AnnotatedMember)factoryCandidates.get((int)0).annotated);
        }
        return null;
    }

    private static KeyDeserializer _constructCreatorKeyDeserializer(DeserializationContext ctxt, AnnotatedMember creator) {
        if (creator instanceof AnnotatedConstructor) {
            AnnotatedElement rawCtor = ((AnnotatedConstructor)creator).getAnnotated();
            if (ctxt.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess((Member)((Object)rawCtor), ctxt.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new JDKKeyDeserializer.StringCtorKeyDeserializer((Constructor<?>)rawCtor);
        }
        Method m = ((AnnotatedMethod)creator).getAnnotated();
        if (ctxt.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(m, ctxt.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new JDKKeyDeserializer.StringFactoryKeyDeserializer(m);
    }

    private static AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> _findStringConstructor(BeanDescription beanDesc) {
        for (AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator.Mode> entry : beanDesc.getConstructorsWithMode()) {
            AnnotatedConstructor ctor = (AnnotatedConstructor)entry.annotated;
            if (ctor.getParameterCount() != 1 || String.class != ctor.getRawParameterType(0)) continue;
            return entry;
        }
        return null;
    }

    private static AnnotatedMethod _findExplicitStringFactoryMethod(DeserializationContext ctxt, List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode>> candidates) throws JacksonException {
        AnnotatedMethod match = null;
        for (AnnotatedAndMetadata<AnnotatedMethod, JsonCreator.Mode> entry : candidates) {
            if (entry.metadata == null) continue;
            if (match == null) {
                match = (AnnotatedMethod)entry.annotated;
                continue;
            }
            Class<?> rawKeyType = ((AnnotatedMethod)entry.annotated).getDeclaringClass();
            throw new IllegalArgumentException("Multiple suitable annotated Creator factory methods to be used as the Key deserializer for type " + ClassUtil.nameOf(rawKeyType));
        }
        return match;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        return JDKKeyDeserializer.forType(raw);
    }
}

