/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext.jdk8;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.util.stream.LongStream;

public class LongStreamSerializer
extends StdSerializer<LongStream> {
    public static final LongStreamSerializer INSTANCE = new LongStreamSerializer();

    private LongStreamSerializer() {
        super(LongStream.class);
    }

    @Override
    public void serialize(LongStream stream, JsonGenerator g, SerializerProvider ctxt) throws JacksonException {
        try (LongStream ls = stream;){
            g.writeStartArray((Object)ls);
            ls.forEach(value -> g.writeNumber(value));
            g.writeEndArray();
        }
        catch (Exception e) {
            this.wrapAndThrow(ctxt, (Throwable)e, (Object)stream, g.streamWriteContext().getCurrentIndex());
        }
    }
}

