/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext.jdk8;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.ext.jdk8.BaseScalarOptionalDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.util.OptionalInt;

public class OptionalIntDeserializer
extends BaseScalarOptionalDeserializer<OptionalInt> {
    static final OptionalIntDeserializer INSTANCE = new OptionalIntDeserializer();

    public OptionalIntDeserializer() {
        super(OptionalInt.class, OptionalInt.empty());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public OptionalInt deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return OptionalInt.of(p.getIntValue());
        }
        switch (p.currentTokenId()) {
            case 6: {
                String text = p.getText();
                CoercionAction act = this._checkFromStringCoercion(ctxt, text);
                if (act == CoercionAction.AsNull) {
                    return (OptionalInt)this.getNullValue(ctxt);
                }
                if (act == CoercionAction.AsEmpty) {
                    return (OptionalInt)this.getEmptyValue(ctxt);
                }
                if (this._checkTextualNull(ctxt, text = text.trim())) {
                    return (OptionalInt)this.getNullValue(ctxt);
                }
                return OptionalInt.of(this._parseIntPrimitive(ctxt, text));
            }
            case 8: {
                CoercionAction act = this._checkFloatToIntCoercion(p, ctxt, this._valueClass);
                if (act == CoercionAction.AsNull) {
                    return (OptionalInt)this.getNullValue(ctxt);
                }
                if (act == CoercionAction.AsEmpty) {
                    return (OptionalInt)this.getEmptyValue(ctxt);
                }
                return OptionalInt.of(p.getValueAsInt());
            }
            case 11: {
                return (OptionalInt)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                OptionalInt parsed = this.deserialize(p, ctxt);
                this._verifyEndArrayForSingle(p, ctxt);
                return parsed;
            }
        }
        return (OptionalInt)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }
}

