/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.bean.BeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.bean.BeanSerializerBase;
import com.fasterxml.jackson.databind.ser.bean.UnwrappingBeanSerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.Set;

@JacksonStdImpl
public class BeanSerializer
extends BeanSerializerBase {
    public BeanSerializer(JavaType type, BeanSerializerBuilder builder, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(type, builder, properties, filteredProperties);
    }

    protected BeanSerializer(BeanSerializerBase src) {
        super(src);
    }

    protected BeanSerializer(BeanSerializerBase src, ObjectIdWriter objectIdWriter) {
        super(src, objectIdWriter);
    }

    protected BeanSerializer(BeanSerializerBase src, ObjectIdWriter objectIdWriter, Object filterId) {
        super(src, objectIdWriter, filterId);
    }

    protected BeanSerializer(BeanSerializerBase src, Set<String> toIgnore, Set<String> toInclude) {
        super(src, toIgnore, toInclude);
    }

    protected BeanSerializer(BeanSerializerBase src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(src, properties, filteredProperties);
    }

    public static BeanSerializer createDummy(JavaType forType, BeanSerializerBuilder builder) {
        return new BeanSerializer(forType, builder, NO_PROPS, null);
    }

    @Override
    public ValueSerializer<Object> unwrappingSerializer(NameTransformer unwrapper) {
        return new UnwrappingBeanSerializer((BeanSerializerBase)this, unwrapper);
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new BeanSerializer((BeanSerializerBase)this, objectIdWriter, this._propertyFilterId);
    }

    @Override
    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanSerializer((BeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    @Override
    protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return new BeanSerializer((BeanSerializerBase)this, toIgnore, toInclude);
    }

    @Override
    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return new BeanSerializer((BeanSerializerBase)this, properties, filteredProperties);
    }

    @Override
    protected BeanSerializerBase asArraySerializer() {
        if (this.canCreateArraySerializer()) {
            return BeanAsArraySerializer.construct(this);
        }
        return this;
    }

    @Override
    public final void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws JacksonException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, provider, true);
            return;
        }
        if (this._propertyFilterId != null) {
            gen.writeStartObject(bean);
            this._serializePropertiesFiltered(bean, gen, provider, this._propertyFilterId);
            gen.writeEndObject();
            return;
        }
        BeanPropertyWriter[] fProps = this._filteredProps;
        if (fProps != null && provider.getActiveView() != null) {
            gen.writeStartObject(bean);
            this._serializePropertiesMaybeView(bean, gen, provider, fProps);
            gen.writeEndObject();
            return;
        }
        gen.writeStartObject(bean);
        this._serializePropertiesNoView(bean, gen, provider, this._props);
        gen.writeEndObject();
    }
}

