/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;

public final class TypeWrappedSerializer
extends ValueSerializer<Object> {
    protected final TypeSerializer _typeSerializer;
    protected final ValueSerializer<Object> _serializer;

    public TypeWrappedSerializer(TypeSerializer typeSer, ValueSerializer<?> ser) {
        this._typeSerializer = typeSer;
        this._serializer = ser;
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializerProvider provider) throws JacksonException {
        this._serializer.serializeWithType(value, g, provider, this._typeSerializer);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws JacksonException {
        this._serializer.serializeWithType(value, g, provider, typeSer);
    }

    @Override
    public Class<Object> handledType() {
        return Object.class;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) {
        ValueSerializer<Object> ser = this._serializer;
        if (ser != null) {
            ser = provider.handleSecondaryContextualization(ser, property);
        }
        if (ser == this._serializer) {
            return this;
        }
        return new TypeWrappedSerializer(this._typeSerializer, ser);
    }

    public ValueSerializer<Object> valueSerializer() {
        return this._serializer;
    }

    public TypeSerializer typeSerializer() {
        return this._typeSerializer;
    }
}

