/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdContainerSerializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.BeanUtil;
import java.util.Map;

@JacksonStdImpl
public class MapEntrySerializer
extends StdContainerSerializer<Map.Entry<?, ?>> {
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _entryType;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected ValueSerializer<Object> _keySerializer;
    protected ValueSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    public MapEntrySerializer(JavaType type, JavaType keyType, JavaType valueType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
        super(type, property);
        this._entryType = type;
        this._keyType = keyType;
        this._valueType = valueType;
        this._valueTypeIsStatic = staticTyping;
        this._valueTypeSerializer = vts;
        this._suppressableValue = null;
        this._suppressNulls = false;
    }

    protected MapEntrySerializer(MapEntrySerializer src, BeanProperty property, TypeSerializer vts, ValueSerializer<?> keySer, ValueSerializer<?> valueSer, Object suppressableValue, boolean suppressNulls) {
        super(src, property);
        this._entryType = src._entryType;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._keySerializer = keySer;
        this._valueSerializer = valueSer;
        this._suppressableValue = suppressableValue;
        this._suppressNulls = suppressNulls;
    }

    @Override
    public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new MapEntrySerializer(this, this._property, vts, this._keySerializer, this._valueSerializer, this._suppressableValue, this._suppressNulls);
    }

    public MapEntrySerializer withResolved(BeanProperty property, ValueSerializer<?> keySerializer, ValueSerializer<?> valueSerializer, Object suppressableValue, boolean suppressNulls) {
        return new MapEntrySerializer(this, property, this._valueTypeSerializer, keySerializer, valueSerializer, suppressableValue, suppressNulls);
    }

    public MapEntrySerializer withContentInclusion(Object suppressableValue, boolean suppressNulls) {
        if (this._suppressableValue == suppressableValue && this._suppressNulls == suppressNulls) {
            return this;
        }
        return new MapEntrySerializer(this, this._property, this._valueTypeSerializer, this._keySerializer, this._valueSerializer, suppressableValue, suppressNulls);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) {
        JsonInclude.Include incl;
        JsonInclude.Value inclV;
        AnnotatedMember propertyAcc;
        ValueSerializer<Object> ser = null;
        ValueSerializer<Object> keySer = null;
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = propertyAcc = property == null ? null : property.getMember();
        if (MapEntrySerializer._neitherNull(propertyAcc, intr)) {
            keySer = provider.serializerInstance(propertyAcc, intr.findKeySerializer(provider.getConfig(), propertyAcc));
            ser = provider.serializerInstance(propertyAcc, intr.findContentSerializer(provider.getConfig(), propertyAcc));
        }
        if (ser == null) {
            ser = this._valueSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(provider, property, ser)) == null && this._valueTypeIsStatic && !this._valueType.isJavaLangObject()) {
            ser = provider.findContentValueSerializer(this._valueType, property);
        }
        if (keySer == null) {
            keySer = this._keySerializer;
        }
        keySer = keySer == null ? provider.findKeySerializer(this._keyType, property) : provider.handleSecondaryContextualization(keySer, property);
        Object valueToSuppress = this._suppressableValue;
        boolean suppressNulls = this._suppressNulls;
        if (property != null && (inclV = property.findPropertyInclusion(provider.getConfig(), null)) != null && (incl = inclV.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            switch (incl) {
                case NON_DEFAULT: {
                    valueToSuppress = BeanUtil.getDefaultValue(this._valueType);
                    suppressNulls = true;
                    if (valueToSuppress == null || !valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = ArrayBuilders.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_ABSENT: {
                    suppressNulls = true;
                    valueToSuppress = this._valueType.isReferenceType() ? MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    valueToSuppress = provider.includeFilterInstance(null, inclV.getContentFilter());
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    suppressNulls = provider.includeFilterSuppressNulls(valueToSuppress);
                    break;
                }
                case NON_NULL: {
                    valueToSuppress = null;
                    suppressNulls = true;
                    break;
                }
                default: {
                    valueToSuppress = null;
                    suppressNulls = false;
                }
            }
        }
        MapEntrySerializer mser = this.withResolved(property, keySer, ser, valueToSuppress, suppressNulls);
        return mser;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public ValueSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean hasSingleElement(Map.Entry<?, ?> value) {
        return true;
    }

    @Override
    public boolean isEmpty(SerializerProvider ctxt, Map.Entry<?, ?> entry) {
        Class<?> cc;
        Object value = entry.getValue();
        if (value == null) {
            return this._suppressNulls;
        }
        if (this._suppressableValue == null) {
            return false;
        }
        ValueSerializer<Object> valueSer = this._valueSerializer;
        if (valueSer == null && (valueSer = this._dynamicValueSerializers.serializerFor(cc = value.getClass())) == null) {
            valueSer = this._findAndAddDynamic(ctxt, cc);
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            return valueSer.isEmpty(ctxt, value);
        }
        return this._suppressableValue.equals(value);
    }

    @Override
    public void serialize(Map.Entry<?, ?> value, JsonGenerator g, SerializerProvider ctxt) throws JacksonException {
        g.writeStartObject(value);
        this.serializeDynamic(value, g, ctxt);
        g.writeEndObject();
    }

    @Override
    public void serializeWithType(Map.Entry<?, ?> value, JsonGenerator g, SerializerProvider ctxt, TypeSerializer typeSer) throws JacksonException {
        g.assignCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_OBJECT));
        this.serializeDynamic(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    protected void serializeDynamic(Map.Entry<?, ?> value, JsonGenerator gen, SerializerProvider ctxt) throws JacksonException {
        ValueSerializer<Object> valueSer;
        TypeSerializer vts = this._valueTypeSerializer;
        Object keyElem = value.getKey();
        ValueSerializer<Object> keySerializer = keyElem == null ? ctxt.findNullKeySerializer(this._keyType, this._property) : this._keySerializer;
        Object valueElem = value.getValue();
        if (valueElem == null) {
            if (this._suppressNulls) {
                return;
            }
            valueSer = ctxt.getDefaultNullValueSerializer();
        } else {
            Class<?> cc;
            valueSer = this._valueSerializer;
            if (valueSer == null && (valueSer = this._dynamicValueSerializers.serializerFor(cc = valueElem.getClass())) == null) {
                valueSer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(ctxt, ctxt.constructSpecializedType(this._valueType, cc)) : this._findAndAddDynamic(ctxt, cc);
            }
            if (this._suppressableValue != null) {
                if (this._suppressableValue == MARKER_FOR_EMPTY && valueSer.isEmpty(ctxt, valueElem)) {
                    return;
                }
                if (this._suppressableValue.equals(valueElem)) {
                    return;
                }
            }
        }
        keySerializer.serialize(keyElem, gen, ctxt);
        try {
            if (vts == null) {
                valueSer.serialize(valueElem, gen, ctxt);
            } else {
                valueSer.serializeWithType(valueElem, gen, ctxt, vts);
            }
        }
        catch (Exception e) {
            String keyDesc = "" + keyElem;
            this.wrapAndThrow(ctxt, (Throwable)e, value, keyDesc);
        }
    }
}

