/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.jdk.CollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T> {
    protected final Boolean _unwrapSingle;

    protected StaticListSerializerBase(Class<?> cls) {
        super(cls);
        this._unwrapSingle = null;
    }

    protected StaticListSerializerBase(StaticListSerializerBase<?> src, Boolean unwrapSingle) {
        super(src);
        this._unwrapSingle = unwrapSingle;
    }

    public abstract ValueSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public ValueSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) {
        ValueSerializer<Object> ser = null;
        if (property != null) {
            AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null) {
                ser = serializers.serializerInstance(m, intr.findContentSerializer(serializers.getConfig(), m));
            }
        }
        Boolean unwrapSingle = null;
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if ((ser = this.findContextualConvertingSerializer(serializers, property, ser)) == null) {
            ser = serializers.findContentValueSerializer(String.class, property);
        }
        if (this.isDefaultSerializer(ser)) {
            if (Objects.equals(unwrapSingle, this._unwrapSingle)) {
                return this;
            }
            return this._withResolved(property, unwrapSingle);
        }
        return new CollectionSerializer(serializers.constructType((Type)((Object)String.class)), true, null, ser);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, T value) {
        return value == null || value.size() == 0;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            this.acceptContentVisitor(v2);
        }
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1);

    @Override
    public abstract void serializeWithType(T var1, JsonGenerator var2, SerializerProvider var3, TypeSerializer var4) throws JacksonException;
}

