/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ValueSerializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdContainerSerializer;
import java.util.Objects;

public abstract class AsArraySerializerBase<T>
extends StdContainerSerializer<T> {
    protected final JavaType _elementType;
    protected final boolean _staticTyping;
    protected final Boolean _unwrapSingle;
    protected final TypeSerializer _valueTypeSerializer;
    protected final ValueSerializer<Object> _elementSerializer;

    protected AsArraySerializerBase(Class<?> cls, JavaType elementType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> elementSerializer) {
        this(cls, elementType, staticTyping, vts, elementSerializer, null);
    }

    protected AsArraySerializerBase(Class<?> cls, JavaType elementType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle) {
        super(cls);
        this._elementType = elementType;
        this._staticTyping = staticTyping || elementType != null && elementType.isFinal();
        this._valueTypeSerializer = vts;
        this._elementSerializer = elementSerializer;
        this._unwrapSingle = unwrapSingle;
    }

    protected AsArraySerializerBase(Class<?> cls, JavaType elementType, boolean staticTyping, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, BeanProperty property) {
        super(cls, property);
        this._elementType = elementType;
        this._staticTyping = staticTyping || elementType != null && elementType.isFinal();
        this._valueTypeSerializer = vts;
        this._elementSerializer = elementSerializer;
        this._unwrapSingle = unwrapSingle;
    }

    protected AsArraySerializerBase(AsArraySerializerBase<?> src, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle, BeanProperty property) {
        super(src, property);
        this._elementType = src._elementType;
        this._staticTyping = src._staticTyping;
        this._valueTypeSerializer = vts;
        this._elementSerializer = elementSerializer;
        this._unwrapSingle = unwrapSingle;
    }

    public abstract AsArraySerializerBase<T> withResolved(BeanProperty var1, TypeSerializer var2, ValueSerializer<?> var3, Boolean var4);

    @Override
    public ValueSerializer<?> createContextual(SerializerProvider ctxt, BeanProperty property) {
        JsonFormat.Value format;
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(ctxt, property);
        }
        ValueSerializer<Object> ser = null;
        Boolean unwrapSingle = null;
        if (property != null) {
            AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null) {
                ser = ctxt.serializerInstance(m, intr.findContentSerializer(ctxt.getConfig(), m));
            }
        }
        if ((format = this.findFormatOverrides(ctxt, property, this.handledType())) != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if ((ser = this.findContextualConvertingSerializer(ctxt, property, ser)) == null && this._elementType != null && this._staticTyping && !this._elementType.isJavaLangObject()) {
            ser = ctxt.findContentValueSerializer(this._elementType, property);
        }
        if (ser != this._elementSerializer || property != this._property || this._valueTypeSerializer != typeSer || !Objects.equals(this._unwrapSingle, unwrapSingle)) {
            return this.withResolved(property, typeSer, ser, unwrapSingle);
        }
        return this;
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public ValueSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_ARRAY));
        g.assignCurrentValue(value);
        this.serializeContents(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws JacksonException;

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JacksonException {
        ValueSerializer<Object> valueSer = this._elementSerializer;
        if (valueSer == null && this._elementType != null) {
            valueSer = visitor.getProvider().findContentValueSerializer(this._elementType, this._property);
        }
        this.visitArrayFormat(visitor, typeHint, valueSer, this._elementType);
    }
}

