/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.util.Snapshottable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.std.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SimpleFilterProvider
extends FilterProvider
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected final Map<String, PropertyFilter> _filtersById;
    protected PropertyFilter _defaultFilter;
    protected boolean _cfgFailOnUnknownId = true;

    public SimpleFilterProvider() {
        this(new HashMap<String, PropertyFilter>());
    }

    public SimpleFilterProvider(Map<String, PropertyFilter> mapping) {
        this._filtersById = mapping;
    }

    protected SimpleFilterProvider(SimpleFilterProvider src) {
        this._defaultFilter = (PropertyFilter)Snapshottable.takeSnapshot((Snapshottable)src._defaultFilter);
        this._cfgFailOnUnknownId = src._cfgFailOnUnknownId;
        Map<String, PropertyFilter> f = src._filtersById;
        if (f.isEmpty()) {
            this._filtersById = new HashMap<String, PropertyFilter>();
        } else {
            this._filtersById = new HashMap<String, PropertyFilter>(f.size());
            f.forEach((k, v) -> this._filtersById.put((String)k, (PropertyFilter)v.snapshot()));
        }
    }

    public SimpleFilterProvider snapshot() {
        return new SimpleFilterProvider(this);
    }

    public SimpleFilterProvider setDefaultFilter(PropertyFilter f) {
        this._defaultFilter = f;
        return this;
    }

    public SimpleFilterProvider setDefaultFilter(SimpleBeanPropertyFilter f) {
        this._defaultFilter = f;
        return this;
    }

    public PropertyFilter getDefaultFilter() {
        return this._defaultFilter;
    }

    public SimpleFilterProvider setFailOnUnknownId(boolean state) {
        this._cfgFailOnUnknownId = state;
        return this;
    }

    public boolean willFailOnUnknownId() {
        return this._cfgFailOnUnknownId;
    }

    public SimpleFilterProvider addFilter(String id, PropertyFilter filter) {
        this._filtersById.put(id, filter);
        return this;
    }

    public SimpleFilterProvider addFilter(String id, SimpleBeanPropertyFilter filter) {
        this._filtersById.put(id, filter);
        return this;
    }

    public PropertyFilter removeFilter(String id) {
        return this._filtersById.remove(id);
    }

    @Override
    public PropertyFilter findPropertyFilter(SerializerProvider ctxt, Object filterId, Object valueToFilter) {
        PropertyFilter f = this._filtersById.get(filterId);
        if (f == null && (f = this._defaultFilter) == null && this._cfgFailOnUnknownId) {
            ctxt.reportMappingProblem("No filter configured with id '%s' (type %s)", filterId, ClassUtil.classNameOf(filterId));
        }
        return f;
    }
}

