/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.LookupCache;
import com.fasterxml.jackson.databind.util.SimpleLookupCache;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LookupCache<ClassKey, PropertyName> _rootNames = new SimpleLookupCache<ClassKey, PropertyName>(20, 200);

    public PropertyName findRootName(DatabindContext ctxt, JavaType rootType) {
        return this.findRootName(ctxt, rootType.getRawClass());
    }

    public PropertyName findRootName(DatabindContext ctxt, Class<?> rootType) {
        ClassKey key = new ClassKey(rootType);
        PropertyName name = this._rootNames.get(key);
        if (name != null) {
            return name;
        }
        AnnotatedClass ac = ctxt.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        name = intr.findRootName(ctxt.getConfig(), ac);
        if (name == null || !name.hasSimpleName()) {
            name = PropertyName.construct(rootType.getSimpleName());
        }
        this._rootNames.put(key, name);
        return name;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

