/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.LookupCache;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class SimpleLookupCache<K, V>
implements LookupCache<K, V>,
Serializable {
    private static final long serialVersionUID = 3L;
    protected final int _initialEntries;
    protected final int _maxEntries;
    protected final transient ConcurrentHashMap<K, V> _map;

    public SimpleLookupCache(int initialEntries, int maxEntries) {
        this._initialEntries = initialEntries;
        this._maxEntries = maxEntries;
        this._map = new ConcurrentHashMap(initialEntries, 0.8f, 4);
    }

    protected Object readResolve() {
        return this.snapshot();
    }

    public SimpleLookupCache<K, V> snapshot() {
        return new SimpleLookupCache<K, V>(this._initialEntries, this._maxEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (this._map.size() >= this._maxEntries) {
            SimpleLookupCache simpleLookupCache = this;
            synchronized (simpleLookupCache) {
                if (this._map.size() >= this._maxEntries) {
                    this.clear();
                }
            }
        }
        return this._map.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (this._map.size() >= this._maxEntries) {
            SimpleLookupCache simpleLookupCache = this;
            synchronized (simpleLookupCache) {
                if (this._map.size() >= this._maxEntries) {
                    this.clear();
                }
            }
        }
        return this._map.putIfAbsent(key, value);
    }

    @Override
    public V get(Object key) {
        return this._map.get(key);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    public void contents(BiConsumer<K, V> consumer) {
        for (Map.Entry<K, V> entry : this._map.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }
}

