/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.AvroTranslators;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import org.apache.avro.Schema;

final class ArrayTranslator
extends AvroTranslator {
    private static final AvroTranslator INSTANCE = new ArrayTranslator();

    private ArrayTranslator() {
    }

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    public void translate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        jsonSchema.setType(NodeType.ARRAY);
        JsonPointer pwd = jsonSchema.getPointer();
        ObjectNode subSchema = FACTORY.objectNode();
        Schema valuesSchema = avroSchema.getElementType();
        jsonSchema.getCurrentNode().put("items", (JsonNode)subSchema);
        jsonSchema.setPointer(pwd.append("items"));
        AvroTranslators.getTranslator(valuesSchema.getType()).translate(valuesSchema, jsonSchema, report);
        jsonSchema.setPointer(pwd);
    }
}

