/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.AvroTranslators;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import org.apache.avro.Schema;

final class MapTranslator
extends AvroTranslator {
    private static final AvroTranslator INSTANCE = new MapTranslator();

    private MapTranslator() {
    }

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    public void translate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        jsonSchema.setType(NodeType.OBJECT);
        JsonPointer pwd = jsonSchema.getPointer();
        ObjectNode subSchema = FACTORY.objectNode();
        Schema valuesSchema = avroSchema.getValueType();
        jsonSchema.getCurrentNode().put("additionalProperties", (JsonNode)subSchema);
        jsonSchema.setPointer(pwd.append("additionalProperties"));
        AvroTranslators.getTranslator(valuesSchema.getType()).translate(valuesSchema, jsonSchema, report);
        jsonSchema.setPointer(pwd);
    }
}

