/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.avro.translators;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.avro.MutableTree;
import com.github.fge.avro.translators.AvroTranslator;
import com.github.fge.avro.translators.AvroTranslators;
import com.github.fge.avro.translators.NamedAvroTypeTranslator;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

final class RecordTranslator
extends NamedAvroTypeTranslator {
    private static final ObjectMapper OLD_MAPPER = new ObjectMapper();
    private static final AvroTranslator INSTANCE = new RecordTranslator();

    private RecordTranslator() {
        super(Schema.Type.RECORD);
    }

    public static AvroTranslator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void doTranslate(Schema avroSchema, MutableTree jsonSchema, ProcessingReport report) throws ProcessingException {
        List fields = avroSchema.getFields();
        if (fields.isEmpty()) {
            ArrayNode node = FACTORY.arrayNode();
            node.add((com.fasterxml.jackson.databind.JsonNode)FACTORY.objectNode());
            jsonSchema.getCurrentNode().put("enum", (com.fasterxml.jackson.databind.JsonNode)node);
            return;
        }
        JsonPointer pwd = jsonSchema.getPointer();
        if (avroSchema.getDoc() != null) {
            jsonSchema.getCurrentNode().put("description", avroSchema.getDoc());
        }
        jsonSchema.setType(NodeType.OBJECT);
        ArrayNode required = FACTORY.arrayNode();
        jsonSchema.getCurrentNode().put("required", (com.fasterxml.jackson.databind.JsonNode)required);
        jsonSchema.getCurrentNode().put("additionalProperties", false);
        ObjectNode properties = FACTORY.objectNode();
        jsonSchema.getCurrentNode().put("properties", (com.fasterxml.jackson.databind.JsonNode)properties);
        for (Schema.Field field : fields) {
            String fieldName = field.name();
            Schema fieldSchema = field.schema();
            Schema.Type fieldType = fieldSchema.getType();
            AvroTranslator translator = AvroTranslators.getTranslator(fieldType);
            required.add(fieldName);
            JsonPointer ptr = JsonPointer.of((Object)"properties", (Object[])new Object[]{fieldName});
            ObjectNode propertyNode = FACTORY.objectNode();
            properties.put(fieldName, (com.fasterxml.jackson.databind.JsonNode)propertyNode);
            RecordTranslator.injectDefault(propertyNode, field);
            jsonSchema.setPointer(pwd.append(ptr));
            translator.translate(fieldSchema, jsonSchema, report);
            jsonSchema.setPointer(pwd);
        }
    }

    private static void injectDefault(ObjectNode propertyNode, Schema.Field field) {
        JsonNode value = field.defaultValue();
        if (value == null) {
            return;
        }
        try {
            String s = OLD_MAPPER.writeValueAsString((Object)value);
            propertyNode.put("default", JsonLoader.fromString((String)s));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

