/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.AbstractSitemapUrlRenderer;
import com.redfin.sitemapgenerator.GoogleNewsSitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.SitemapGenerator;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.SitemapGeneratorOptions;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleNewsSitemapGenerator
extends SitemapGenerator<GoogleNewsSitemapUrl, GoogleNewsSitemapGenerator> {
    public static final int MAX_URLS_PER_SITEMAP = 1000;

    public static SitemapGeneratorBuilder<GoogleNewsSitemapGenerator> builder(URL baseUrl, File baseDir) {
        SitemapGeneratorBuilder<GoogleNewsSitemapGenerator> builder = new SitemapGeneratorBuilder<GoogleNewsSitemapGenerator>(baseUrl, baseDir, GoogleNewsSitemapGenerator.class);
        builder.maxUrls = 1000;
        return builder;
    }

    public static SitemapGeneratorBuilder<GoogleNewsSitemapGenerator> builder(String baseUrl, File baseDir) throws MalformedURLException {
        SitemapGeneratorBuilder<GoogleNewsSitemapGenerator> builder = new SitemapGeneratorBuilder<GoogleNewsSitemapGenerator>(baseUrl, baseDir, GoogleNewsSitemapGenerator.class);
        builder.maxUrls = 1000;
        return builder;
    }

    GoogleNewsSitemapGenerator(AbstractSitemapGeneratorOptions<?> options) {
        super(options, new Renderer());
        if (options.maxUrls > 1000) {
            throw new RuntimeException("Google News sitemaps can have only 1000 URLs per sitemap: " + options.maxUrls);
        }
    }

    public GoogleNewsSitemapGenerator(String baseUrl, File baseDir) throws MalformedURLException {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleNewsSitemapGenerator(URL baseUrl, File baseDir) {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Renderer
    extends AbstractSitemapUrlRenderer<GoogleNewsSitemapUrl>
    implements ISitemapUrlRenderer<GoogleNewsSitemapUrl> {
        private Renderer() {
        }

        @Override
        public Class<GoogleNewsSitemapUrl> getUrlClass() {
            return GoogleNewsSitemapUrl.class;
        }

        @Override
        public void render(GoogleNewsSitemapUrl url, OutputStreamWriter out, W3CDateFormat dateFormat) throws IOException {
            StringBuilder sb = new StringBuilder();
            sb.append("    <news:news>\n");
            this.renderTag(sb, "news", "publication_date", dateFormat.format(url.getPublicationDate()));
            this.renderTag(sb, "news", "keywords", url.getKeywords());
            sb.append("    </news:news>\n");
            super.render(url, out, dateFormat, sb.toString());
        }

        @Override
        public String getXmlNamespaces() {
            return "xmlns:news=\"http://www.google.com/schemas/sitemap-news/0.9\"";
        }
    }
}

