/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher.graphviz;

import com.google.inject.grapher.NodeAliasFactory;
import com.google.inject.grapher.Renderer;
import com.google.inject.grapher.graphviz.ArrowType;
import com.google.inject.grapher.graphviz.CompassPoint;
import com.google.inject.grapher.graphviz.GraphvizEdge;
import com.google.inject.grapher.graphviz.GraphvizNode;
import com.google.inject.grapher.graphviz.NodeStyle;
import com.google.inject.internal.util.;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizRenderer
implements Renderer,
NodeAliasFactory<String> {
    private final List<GraphvizNode> nodes = .Lists.newArrayList();
    private final List<GraphvizEdge> edges = .Lists.newArrayList();
    private final Map<String, String> aliases = .Maps.newHashMap();
    private PrintWriter out;
    private String rankdir = "TB";

    public GraphvizRenderer setOut(PrintWriter out) {
        this.out = out;
        return this;
    }

    public GraphvizRenderer setRankdir(String rankdir) {
        this.rankdir = rankdir;
        return this;
    }

    public void addNode(GraphvizNode node) {
        this.nodes.add(node);
    }

    public void addEdge(GraphvizEdge edge) {
        this.edges.add(edge);
    }

    @Override
    public void newAlias(String fromId, String toId) {
        this.aliases.put(fromId, toId);
    }

    protected String resolveAlias(String id) {
        while (this.aliases.containsKey(id)) {
            id = this.aliases.get(id);
        }
        return id;
    }

    @Override
    public void render() {
        this.start();
        for (GraphvizNode node : this.nodes) {
            this.renderNode(node);
        }
        for (GraphvizEdge edge : this.edges) {
            this.renderEdge(edge);
        }
        this.finish();
        this.out.flush();
    }

    protected Map<String, String> getGraphAttributes() {
        HashMap attrs = .Maps.newHashMap();
        attrs.put("rankdir", this.rankdir);
        return attrs;
    }

    protected void start() {
        this.out.println("digraph injector {");
        Map<String, String> attrs = this.getGraphAttributes();
        this.out.println("graph " + this.getAttrString(attrs) + ";");
    }

    protected void finish() {
        this.out.println("}");
    }

    protected void renderNode(GraphvizNode node) {
        Map<String, String> attrs = this.getNodeAttributes(node);
        this.out.println(node.getNodeId() + " " + this.getAttrString(attrs));
    }

    protected Map<String, String> getNodeAttributes(GraphvizNode node) {
        HashMap attrs = .Maps.newHashMap();
        attrs.put("label", this.getNodeLabel(node));
        attrs.put("margin", "0.02,0");
        attrs.put("shape", node.getShape().toString());
        attrs.put("style", node.getStyle().toString());
        return attrs;
    }

    protected String getNodeLabel(GraphvizNode node) {
        String cellborder = node.getStyle() == NodeStyle.INVISIBLE ? "1" : "0";
        StringBuilder html = new StringBuilder();
        html.append("<");
        html.append("<table cellspacing=\"0\" cellpadding=\"5\" cellborder=\"");
        html.append(cellborder).append("\" border=\"0\">");
        html.append("<tr>").append("<td align=\"left\" port=\"header\" ");
        html.append("bgcolor=\"" + node.getHeaderBackgroundColor() + "\">");
        String subtitle = .Join.join((String)"<br align=\"left\"/>", node.getSubtitles());
        if (subtitle.length() != 0) {
            html.append("<font color=\"").append(node.getHeaderTextColor());
            html.append("\" point-size=\"10\">");
            html.append(subtitle).append("<br align=\"left\"/>").append("</font>");
        }
        html.append("<font color=\"" + node.getHeaderTextColor() + "\">");
        html.append(this.htmlEscape(node.getTitle())).append("<br align=\"left\"/>");
        html.append("</font>").append("</td>").append("</tr>");
        for (Map.Entry<String, String> field : node.getFields().entrySet()) {
            html.append("<tr>");
            html.append("<td align=\"left\" port=\"").append(field.getKey()).append("\">");
            html.append(this.htmlEscape(field.getValue()));
            html.append("</td>").append("</tr>");
        }
        html.append("</table>");
        html.append(">");
        return html.toString();
    }

    protected void renderEdge(GraphvizEdge edge) {
        Map<String, String> attrs = this.getEdgeAttributes(edge);
        String tailId = this.getEdgeEndPoint(this.resolveAlias(edge.getTailNodeId()), edge.getTailPortId(), edge.getTailCompassPoint());
        String headId = this.getEdgeEndPoint(this.resolveAlias(edge.getHeadNodeId()), edge.getHeadPortId(), edge.getHeadCompassPoint());
        this.out.println(tailId + " -> " + headId + " " + this.getAttrString(attrs));
    }

    protected Map<String, String> getEdgeAttributes(GraphvizEdge edge) {
        HashMap attrs = .Maps.newHashMap();
        attrs.put("arrowhead", this.getArrowString(edge.getArrowHead()));
        attrs.put("arrowtail", this.getArrowString(edge.getArrowTail()));
        attrs.put("style", edge.getStyle().toString());
        return attrs;
    }

    private String getAttrString(Map<String, String> attrs) {
        ArrayList attrList = .Lists.newArrayList();
        for (Map.Entry<String, String> attr : attrs.entrySet()) {
            String value = attr.getValue();
            if (value == null) continue;
            attrList.add(attr.getKey() + "=" + value);
        }
        return "[" + .Join.join((String)", ", (Iterable)attrList) + "]";
    }

    protected String getArrowString(List<ArrowType> arrows) {
        return .Join.join((String)"", arrows);
    }

    protected String getEdgeEndPoint(String nodeId, String portId, CompassPoint compassPoint) {
        ArrayList portStrings = .Lists.newArrayList((Object[])new String[]{nodeId});
        if (portId != null) {
            portStrings.add(portId);
        }
        if (compassPoint != null) {
            portStrings.add(compassPoint.toString());
        }
        return .Join.join((String)":", (Iterable)portStrings);
    }

    protected String htmlEscape(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

