/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.collect.ImmutableSortedSet;
import com.google.monitoring.metrics.ExponentialFitter;

final class AutoValue_ExponentialFitter
extends ExponentialFitter {
    private final double base;
    private final double scale;
    private final ImmutableSortedSet<Double> boundaries;

    AutoValue_ExponentialFitter(double base, double scale, ImmutableSortedSet<Double> boundaries) {
        this.base = base;
        this.scale = scale;
        if (boundaries == null) {
            throw new NullPointerException("Null boundaries");
        }
        this.boundaries = boundaries;
    }

    @Override
    public double base() {
        return this.base;
    }

    @Override
    public double scale() {
        return this.scale;
    }

    @Override
    public ImmutableSortedSet<Double> boundaries() {
        return this.boundaries;
    }

    public String toString() {
        return "ExponentialFitter{base=" + this.base + ", scale=" + this.scale + ", boundaries=" + this.boundaries + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExponentialFitter) {
            ExponentialFitter that = (ExponentialFitter)o;
            return Double.doubleToLongBits(this.base) == Double.doubleToLongBits(that.base()) && Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(that.scale()) && this.boundaries.equals(that.boundaries());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= (int)(Double.doubleToLongBits(this.base) >>> 32 ^ Double.doubleToLongBits(this.base));
        h *= 1000003;
        h ^= (int)(Double.doubleToLongBits(this.scale) >>> 32 ^ Double.doubleToLongBits(this.scale));
        h *= 1000003;
        return h ^= this.boundaries.hashCode();
    }
}

