/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.collect.ImmutableRangeMap;
import com.google.monitoring.metrics.DistributionFitter;
import com.google.monitoring.metrics.ImmutableDistribution;

final class AutoValue_ImmutableDistribution
extends ImmutableDistribution {
    private final double mean;
    private final double sumOfSquaredDeviation;
    private final long count;
    private final ImmutableRangeMap<Double, Long> intervalCounts;
    private final DistributionFitter distributionFitter;

    AutoValue_ImmutableDistribution(double mean, double sumOfSquaredDeviation, long count, ImmutableRangeMap<Double, Long> intervalCounts, DistributionFitter distributionFitter) {
        this.mean = mean;
        this.sumOfSquaredDeviation = sumOfSquaredDeviation;
        this.count = count;
        if (intervalCounts == null) {
            throw new NullPointerException("Null intervalCounts");
        }
        this.intervalCounts = intervalCounts;
        if (distributionFitter == null) {
            throw new NullPointerException("Null distributionFitter");
        }
        this.distributionFitter = distributionFitter;
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double sumOfSquaredDeviation() {
        return this.sumOfSquaredDeviation;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public ImmutableRangeMap<Double, Long> intervalCounts() {
        return this.intervalCounts;
    }

    @Override
    public DistributionFitter distributionFitter() {
        return this.distributionFitter;
    }

    public String toString() {
        return "ImmutableDistribution{mean=" + this.mean + ", sumOfSquaredDeviation=" + this.sumOfSquaredDeviation + ", count=" + this.count + ", intervalCounts=" + this.intervalCounts + ", distributionFitter=" + this.distributionFitter + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableDistribution) {
            ImmutableDistribution that = (ImmutableDistribution)o;
            return Double.doubleToLongBits(this.mean) == Double.doubleToLongBits(that.mean()) && Double.doubleToLongBits(this.sumOfSquaredDeviation) == Double.doubleToLongBits(that.sumOfSquaredDeviation()) && this.count == that.count() && this.intervalCounts.equals(that.intervalCounts()) && this.distributionFitter.equals(that.distributionFitter());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= (int)(Double.doubleToLongBits(this.mean) >>> 32 ^ Double.doubleToLongBits(this.mean));
        h *= 1000003;
        h ^= (int)(Double.doubleToLongBits(this.sumOfSquaredDeviation) >>> 32 ^ Double.doubleToLongBits(this.sumOfSquaredDeviation));
        h *= 1000003;
        h ^= (int)(this.count >>> 32 ^ this.count);
        h *= 1000003;
        h ^= this.intervalCounts.hashCode();
        h *= 1000003;
        return h ^= this.distributionFitter.hashCode();
    }
}

