/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.collect.ImmutableSortedSet;
import com.google.monitoring.metrics.LinearFitter;

final class AutoValue_LinearFitter
extends LinearFitter {
    private final double width;
    private final double offset;
    private final ImmutableSortedSet<Double> boundaries;

    AutoValue_LinearFitter(double width, double offset, ImmutableSortedSet<Double> boundaries) {
        this.width = width;
        this.offset = offset;
        if (boundaries == null) {
            throw new NullPointerException("Null boundaries");
        }
        this.boundaries = boundaries;
    }

    @Override
    public double width() {
        return this.width;
    }

    @Override
    public double offset() {
        return this.offset;
    }

    @Override
    public ImmutableSortedSet<Double> boundaries() {
        return this.boundaries;
    }

    public String toString() {
        return "LinearFitter{width=" + this.width + ", offset=" + this.offset + ", boundaries=" + this.boundaries + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LinearFitter) {
            LinearFitter that = (LinearFitter)o;
            return Double.doubleToLongBits(this.width) == Double.doubleToLongBits(that.width()) && Double.doubleToLongBits(this.offset) == Double.doubleToLongBits(that.offset()) && this.boundaries.equals(that.boundaries());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= (int)(Double.doubleToLongBits(this.width) >>> 32 ^ Double.doubleToLongBits(this.width));
        h *= 1000003;
        h ^= (int)(Double.doubleToLongBits(this.offset) >>> 32 ^ Double.doubleToLongBits(this.offset));
        h *= 1000003;
        return h ^= this.boundaries.hashCode();
    }
}

