/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.AtomicLongMap;
import com.google.common.util.concurrent.Striped;
import com.google.monitoring.metrics.AbstractMetric;
import com.google.monitoring.metrics.IncrementableMetric;
import com.google.monitoring.metrics.LabelDescriptor;
import com.google.monitoring.metrics.MetricPoint;
import com.google.monitoring.metrics.MetricSchema;
import com.google.monitoring.metrics.MetricsUtils;
import com.google.monitoring.metrics.SettableMetric;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Instant;

@ThreadSafe
public final class Counter
extends AbstractMetric<Long>
implements SettableMetric<Long>,
IncrementableMetric {
    private final AtomicLongMap<ImmutableList<String>> values = AtomicLongMap.create();
    private final ConcurrentHashMap<ImmutableList<String>, Instant> valueStartTimestamps = MetricsUtils.newConcurrentHashMap(16);
    private final Striped<Lock> valueLocks = Striped.lock((int)16);

    Counter(String name, String description, String valueDisplayName, ImmutableSet<LabelDescriptor> labels) {
        super(name, description, valueDisplayName, MetricSchema.Kind.CUMULATIVE, labels, Long.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void incrementBy(long offset, Instant startTimestamp, ImmutableList<String> labelValues) {
        Lock lock = (Lock)this.valueLocks.get(labelValues);
        lock.lock();
        try {
            this.values.addAndGet(labelValues, offset);
            this.valueStartTimestamps.putIfAbsent(labelValues, startTimestamp);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public final void incrementBy(long offset, String ... labelValues) {
        MetricsUtils.checkLabelValuesLength(this, labelValues);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"The offset provided must be non-negative");
        this.incrementBy(offset, Instant.now(), (ImmutableList<String>)ImmutableList.copyOf((Object[])labelValues));
    }

    @Override
    public final void increment(String ... labelValues) {
        MetricsUtils.checkLabelValuesLength(this, labelValues);
        this.incrementBy(1L, Instant.now(), (ImmutableList<String>)ImmutableList.copyOf((Object[])labelValues));
    }

    @Override
    public final ImmutableList<MetricPoint<Long>> getTimestampedValues() {
        return this.getTimestampedValues(Instant.now());
    }

    @Override
    public final int getCardinality() {
        return this.values.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final ImmutableList<MetricPoint<Long>> getTimestampedValues(Instant endTimestamp) {
        ImmutableList.Builder timestampedValues = new ImmutableList.Builder();
        for (Map.Entry entry : this.values.asMap().entrySet()) {
            Instant startTimestamp;
            ImmutableList labelValues = (ImmutableList)entry.getKey();
            ((Lock)this.valueLocks.get((Object)labelValues)).lock();
            try {
                startTimestamp = this.valueStartTimestamps.get(labelValues);
            }
            finally {
                ((Lock)this.valueLocks.get((Object)labelValues)).unlock();
            }
            endTimestamp = (Instant)Ordering.natural().max((Object)startTimestamp, (Object)endTimestamp);
            timestampedValues.add(MetricPoint.create(this, (ImmutableList<String>)labelValues, startTimestamp, endTimestamp, entry.getValue()));
        }
        return timestampedValues.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final void set(Long value, Instant startTimestamp, ImmutableList<String> labelValues) {
        Lock lock = (Lock)this.valueLocks.get(labelValues);
        lock.lock();
        try {
            this.values.put(labelValues, value.longValue());
            this.valueStartTimestamps.putIfAbsent(labelValues, startTimestamp);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public final void set(Long value, String ... labelValues) {
        MetricsUtils.checkLabelValuesLength(this, labelValues);
        this.set(value, Instant.now(), (ImmutableList<String>)ImmutableList.copyOf((Object[])labelValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final void reset(Instant startTimestamp) {
        for (int i = 0; i < this.valueLocks.size(); ++i) {
            ((Lock)this.valueLocks.getAt(i)).lock();
        }
        try {
            for (ImmutableList labelValues : this.values.asMap().keySet()) {
                this.values.put((Object)labelValues, 0L);
                this.valueStartTimestamps.put((ImmutableList<String>)labelValues, startTimestamp);
            }
        }
        finally {
            for (int i = 0; i < this.valueLocks.size(); ++i) {
                ((Lock)this.valueLocks.getAt(i)).unlock();
            }
        }
    }

    @Override
    public final void reset() {
        this.reset(Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final void reset(Instant startTimestamp, ImmutableList<String> labelValues) {
        Lock lock = (Lock)this.valueLocks.get(labelValues);
        lock.lock();
        try {
            this.values.put(labelValues, 0L);
            this.valueStartTimestamps.put(labelValues, startTimestamp);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public final void reset(String ... labelValues) {
        MetricsUtils.checkLabelValuesLength(this, labelValues);
        this.reset(Instant.now(), (ImmutableList<String>)ImmutableList.copyOf((Object[])labelValues));
    }
}

