/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Striped;
import com.google.monitoring.metrics.AbstractMetric;
import com.google.monitoring.metrics.Distribution;
import com.google.monitoring.metrics.DistributionFitter;
import com.google.monitoring.metrics.ExponentialFitter;
import com.google.monitoring.metrics.ImmutableDistribution;
import com.google.monitoring.metrics.LabelDescriptor;
import com.google.monitoring.metrics.MetricPoint;
import com.google.monitoring.metrics.MetricSchema;
import com.google.monitoring.metrics.MetricsUtils;
import com.google.monitoring.metrics.MutableDistribution;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.joda.time.Instant;

public class EventMetric
extends AbstractMetric<Distribution> {
    public static final DistributionFitter DEFAULT_FITTER = ExponentialFitter.create(16, 4.0, 1.0);
    private final ConcurrentHashMap<ImmutableList<String>, Instant> valueStartTimestamps = MetricsUtils.newConcurrentHashMap(16);
    private final ConcurrentHashMap<ImmutableList<String>, MutableDistribution> values = MetricsUtils.newConcurrentHashMap(16);
    private final DistributionFitter distributionFitter;
    private final Striped<Lock> valueLocks = Striped.lock((int)16);

    EventMetric(String name, String description, String valueDisplayName, DistributionFitter distributionFitter, ImmutableSet<LabelDescriptor> labels) {
        super(name, description, valueDisplayName, MetricSchema.Kind.CUMULATIVE, labels, Distribution.class);
        this.distributionFitter = distributionFitter;
    }

    @Override
    public final int getCardinality() {
        return this.values.size();
    }

    @Override
    public final ImmutableList<MetricPoint<Distribution>> getTimestampedValues() {
        return this.getTimestampedValues(Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ImmutableList<MetricPoint<Distribution>> getTimestampedValues(Instant endTimestamp) {
        ImmutableList.Builder timestampedValues = new ImmutableList.Builder();
        for (Map.Entry<ImmutableList<String>, MutableDistribution> entry : this.values.entrySet()) {
            ImmutableDistribution distribution;
            Instant startTimestamp;
            ImmutableList<String> labelValues = entry.getKey();
            Lock lock = (Lock)this.valueLocks.get(labelValues);
            lock.lock();
            try {
                startTimestamp = this.valueStartTimestamps.get(labelValues);
                distribution = ImmutableDistribution.copyOf(entry.getValue());
            }
            finally {
                lock.unlock();
            }
            endTimestamp = (Instant)Ordering.natural().max((Object)startTimestamp, (Object)endTimestamp);
            timestampedValues.add(MetricPoint.create(this, labelValues, startTimestamp, endTimestamp, distribution));
        }
        return timestampedValues.build();
    }

    public void record(double sample, String ... labelValues) {
        MetricsUtils.checkLabelValuesLength(this, labelValues);
        this.recordMultiple(sample, 1, Instant.now(), (ImmutableList<String>)ImmutableList.copyOf((Object[])labelValues));
    }

    public void record(double sample, int count, String ... labelValues) {
        MetricsUtils.checkLabelValuesLength(this, labelValues);
        this.recordMultiple(sample, count, Instant.now(), (ImmutableList<String>)ImmutableList.copyOf((Object[])labelValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void recordMultiple(double sample, int count, Instant startTimestamp, ImmutableList<String> labelValues) {
        Lock lock = (Lock)this.valueLocks.get(labelValues);
        lock.lock();
        try {
            this.values.computeIfAbsent(labelValues, k -> new MutableDistribution(this.distributionFitter));
            this.values.get(labelValues).add(sample, count);
            this.valueStartTimestamps.putIfAbsent(labelValues, startTimestamp);
        }
        finally {
            lock.unlock();
        }
    }

    public void reset() {
        this.reset(Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final void reset(Instant startTime) {
        for (int i = 0; i < this.valueLocks.size(); ++i) {
            ((Lock)this.valueLocks.getAt(i)).lock();
        }
        try {
            for (ImmutableList labelValues : this.values.keySet()) {
                this.values.put((ImmutableList<String>)labelValues, new MutableDistribution(this.distributionFitter));
                this.valueStartTimestamps.put((ImmutableList<String>)labelValues, startTime);
            }
        }
        finally {
            for (int i = 0; i < this.valueLocks.size(); ++i) {
                ((Lock)this.valueLocks.getAt(i)).unlock();
            }
        }
    }

    public void reset(String ... labelValues) {
        MetricsUtils.checkLabelValuesLength(this, labelValues);
        this.reset(Instant.now(), (ImmutableList<String>)ImmutableList.copyOf((Object[])labelValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final void reset(Instant startTimestamp, ImmutableList<String> labelValues) {
        Lock lock = (Lock)this.valueLocks.get(labelValues);
        lock.lock();
        try {
            this.values.put(labelValues, new MutableDistribution(this.distributionFitter));
            this.valueStartTimestamps.put(labelValues, startTimestamp);
        }
        finally {
            lock.unlock();
        }
    }
}

