/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.monitoring.metrics.AutoValue_ExponentialFitter;
import com.google.monitoring.metrics.DistributionFitter;
import com.google.monitoring.metrics.MetricsUtils;

@AutoValue
public abstract class ExponentialFitter
implements DistributionFitter {
    public static ExponentialFitter create(int numFiniteIntervals, double base, double scale) {
        Preconditions.checkArgument((numFiniteIntervals > 0 ? 1 : 0) != 0, (Object)"numFiniteIntervals must be greater than 0");
        Preconditions.checkArgument((scale != 0.0 ? 1 : 0) != 0, (Object)"scale must not be 0");
        Preconditions.checkArgument((base > 1.0 ? 1 : 0) != 0, (Object)"base must be greater than 1");
        MetricsUtils.checkDouble(base);
        MetricsUtils.checkDouble(scale);
        ImmutableSortedSet.Builder boundaries = ImmutableSortedSet.naturalOrder();
        for (int i = 0; i < numFiniteIntervals + 1; ++i) {
            boundaries.add((Object)(scale * Math.pow(base, i)));
        }
        return new AutoValue_ExponentialFitter(base, scale, (ImmutableSortedSet<Double>)boundaries.build());
    }

    public abstract double base();

    public abstract double scale();

    @Override
    public abstract ImmutableSortedSet<Double> boundaries();
}

