/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.monitoring.metrics.CustomFitter;

public final class FibonacciFitter {
    public static CustomFitter create(long maxBucketSize) {
        Preconditions.checkArgument((maxBucketSize > 0L ? 1 : 0) != 0, (Object)"maxBucketSize must be greater than 0");
        ImmutableSortedSet.Builder boundaries = ImmutableSortedSet.naturalOrder();
        boundaries.add((Object)0.0);
        long i = 1L;
        long j = 2L;
        long k = 3L;
        while (i <= maxBucketSize) {
            boundaries.add((Object)i);
            i = j;
            j = k;
            k = i + j;
        }
        return CustomFitter.create((ImmutableSet<Double>)boundaries.build());
    }

    private FibonacciFitter() {
    }
}

