/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableRangeMap;
import com.google.monitoring.metrics.AutoValue_ImmutableDistribution;
import com.google.monitoring.metrics.Distribution;
import com.google.monitoring.metrics.DistributionFitter;
import com.google.monitoring.metrics.MetricsUtils;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@AutoValue
public abstract class ImmutableDistribution
implements Distribution {
    public static ImmutableDistribution copyOf(Distribution distribution) {
        return new AutoValue_ImmutableDistribution(distribution.mean(), distribution.sumOfSquaredDeviation(), distribution.count(), distribution.intervalCounts(), distribution.distributionFitter());
    }

    @VisibleForTesting
    static ImmutableDistribution create(double mean, double sumOfSquaredDeviation, long count, ImmutableRangeMap<Double, Long> intervalCounts, DistributionFitter distributionFitter) {
        MetricsUtils.checkDouble(mean);
        MetricsUtils.checkDouble(sumOfSquaredDeviation);
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0);
        return new AutoValue_ImmutableDistribution(mean, sumOfSquaredDeviation, count, intervalCounts, distributionFitter);
    }

    @Override
    public abstract double mean();

    @Override
    public abstract double sumOfSquaredDeviation();

    @Override
    public abstract long count();

    @Override
    public abstract ImmutableRangeMap<Double, Long> intervalCounts();

    @Override
    public abstract DistributionFitter distributionFitter();
}

