/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.monitoring.metrics.AutoValue_LabelDescriptor;
import com.google.re2j.Pattern;

@AutoValue
public abstract class LabelDescriptor {
    private static final Pattern ALLOWED_LABEL_PATTERN = Pattern.compile((String)"\\w+");

    LabelDescriptor() {
    }

    public static LabelDescriptor create(String name, String description) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name must not be empty");
        Preconditions.checkArgument((!description.isEmpty() ? 1 : 0) != 0, (Object)"Description must not be empty");
        Preconditions.checkArgument((boolean)ALLOWED_LABEL_PATTERN.matches(name), (String)"Label name must match the regex %s", (Object)ALLOWED_LABEL_PATTERN);
        return new AutoValue_LabelDescriptor(name, description);
    }

    public abstract String name();

    public abstract String description();
}

