/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.monitoring.metrics.AutoValue_LinearFitter;
import com.google.monitoring.metrics.DistributionFitter;
import com.google.monitoring.metrics.MetricsUtils;

@AutoValue
public abstract class LinearFitter
implements DistributionFitter {
    public static LinearFitter create(int numFiniteIntervals, double width, double offset) {
        Preconditions.checkArgument((numFiniteIntervals > 0 ? 1 : 0) != 0, (Object)"numFiniteIntervals must be greater than 0");
        Preconditions.checkArgument((width > 0.0 ? 1 : 0) != 0, (Object)"width must be greater than 0");
        MetricsUtils.checkDouble(offset);
        ImmutableSortedSet.Builder boundaries = ImmutableSortedSet.naturalOrder();
        for (int i = 0; i < numFiniteIntervals + 1; ++i) {
            boundaries.add((Object)(width * (double)i + offset));
        }
        return new AutoValue_LinearFitter(width, offset, (ImmutableSortedSet<Double>)boundaries.build());
    }

    public abstract double width();

    public abstract double offset();

    @Override
    public abstract ImmutableSortedSet<Double> boundaries();
}

