/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.monitoring.metrics.MetricPoint;
import com.google.monitoring.metrics.MetricReporter;
import com.google.monitoring.metrics.MetricWriter;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

class MetricExporter
extends AbstractExecutionThreadService {
    private static final Logger logger = Logger.getLogger(MetricReporter.class.getName());
    private final BlockingQueue<Optional<ImmutableList<MetricPoint<?>>>> writeQueue;
    private final MetricWriter writer;
    private final ThreadFactory threadFactory;

    MetricExporter(BlockingQueue<Optional<ImmutableList<MetricPoint<?>>>> writeQueue, MetricWriter writer, ThreadFactory threadFactory) {
        this.writeQueue = writeQueue;
        this.writer = writer;
        this.threadFactory = threadFactory;
    }

    protected void run() throws Exception {
        logger.info("Started up MetricExporter");
        while (this.isRunning()) {
            Optional<ImmutableList<MetricPoint<?>>> batch = this.writeQueue.take();
            logger.info("Got a batch of points from the writeQueue");
            if (batch.isPresent()) {
                logger.info("Batch contains data, writing to MetricWriter");
                try {
                    for (MetricPoint point : batch.get()) {
                        this.writer.write(point);
                    }
                    this.writer.flush();
                }
                catch (IOException exception) {
                    logger.log(Level.SEVERE, "Threw an exception while writing or flushing metrics", exception);
                }
                continue;
            }
            logger.info("Received a poison pill, stopping now");
            return;
        }
    }

    protected Executor executor() {
        final ExecutorService executor = Executors.newSingleThreadExecutor(this.threadFactory);
        this.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                executor.shutdown();
            }

            public void failed(Service.State from, Throwable failure) {
                executor.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return executor;
    }
}

