/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.monitoring.metrics.IncrementableMetric;
import com.google.monitoring.metrics.LabelDescriptor;
import com.google.monitoring.metrics.Metric;
import com.google.monitoring.metrics.MetricRegistryImpl;
import java.util.HashMap;

final class MetricMetrics {
    static final IncrementableMetric pushIntervals = MetricRegistryImpl.getDefault().newIncrementableMetric("/metrics/push_intervals", "Count of push intervals.", "Push Intervals", (ImmutableSet<LabelDescriptor>)ImmutableSet.of());
    private static final ImmutableSet<LabelDescriptor> LABELS = ImmutableSet.of((Object)LabelDescriptor.create("kind", "Metric Kind"), (Object)LabelDescriptor.create("valueType", "Metric Value Type"));
    static final IncrementableMetric pushedPoints = MetricRegistryImpl.getDefault().newIncrementableMetric("/metrics/points_pushed", "Count of points pushed to Monitoring API.", "Points Pushed", LABELS);
    private static final Metric<Long> timeseriesCount = MetricRegistryImpl.getDefault().newGauge("/metrics/timeseries_count", "Count of Timeseries being pushed to Monitoring API", "Timeseries Count", LABELS, () -> {
        HashMap<ImmutableList, Long> timeseriesCount = new HashMap<ImmutableList, Long>();
        for (Metric metric : MetricRegistryImpl.getDefault().getRegisteredMetrics()) {
            ImmutableList key = ImmutableList.of((Object)metric.getMetricSchema().kind().toString(), (Object)metric.getValueClass().toString());
            int cardinality = metric.getCardinality();
            if (!timeseriesCount.containsKey(key)) {
                timeseriesCount.put(key, Long.valueOf(cardinality));
                continue;
            }
            timeseriesCount.put(key, (Long)timeseriesCount.get(key) + (long)cardinality);
        }
        return ImmutableMap.copyOf(timeseriesCount);
    }, Long.class);

    private MetricMetrics() {
    }
}

